###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for nagios FEDORA-2007-4123
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861099);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-4123");
  script_cve_id("CVE-2007-5624");
  script_name( "Fedora Update for nagios FEDORA-2007-4123");
  desc = "

  Vulnerability Insight:
  Nagios is a program that will monitor hosts and services on your
  network.  It has the ability to send email or page alerts when a
  problem arises and when a problem is resolved.  Nagios is written
  in C and is designed to run under Linux (and some other *NIX
  variants) as a background process, intermittently running checks
  on various services that you specify.
  
  The actual service checks are performed by separate &quot;plugin&quot; programs
  which return the status of the checks to Nagios. The plugins are
  available at <a  rel= &qt nofollow &qt  href= &qt http://sourceforge.net/projects/nagiosplug &qt >http://sourceforge.net/projects/nagiosplug</a>.
  
  This package provides the core program, web interface, and documentation
  files for Nagios. Development files are built as a separate package.


  Affected Software/OS:
  nagios on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00125.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nagios");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"nagios", rpm:"nagios~2.10~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nagios-debuginfo", rpm:"nagios-debuginfo~2.10~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nagios", rpm:"nagios~2.10~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nagios-devel", rpm:"nagios-devel~2.10~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nagios-devel", rpm:"nagios-devel~2.10~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nagios", rpm:"nagios~2.10~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nagios-debuginfo", rpm:"nagios-debuginfo~2.10~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}