###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for apache2 vulnerabilities USN-908-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840399);
  script_version("$Revision: 8167 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "908-1");
  script_cve_id("CVE-2010-0408", "CVE-2010-0434");
  script_name("Ubuntu Update for apache2 vulnerabilities USN-908-1");
  desc = "

  Vulnerability Insight:

  It was discovered that mod_proxy_ajp did not properly handle errors when
  a client doesn't send a request body. A remote attacker could exploit this
  with a crafted request and cause a denial of service. This issue affected
  Ubuntu 8.04 LTS, 8.10, 9.04 and 9.10. (CVE-2010-0408)
  
  It was discovered that Apache did not properly handle headers in
  subrequests under certain conditions. A remote attacker could exploit this
  with a crafted request and possibly obtain sensitive information from
  previous requests. (CVE-2010-0434)

  Affected Software/OS:
  apache2 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-March/001057.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of apache2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.11-2ubuntu2.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu2.10", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.2.9-7ubuntu3.6", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.2.8-1ubuntu0.15", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-bin", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"apache2-mpm-itk", ver:"2.2.12-1ubuntu2.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}