###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vlc_media_player_mult_bof_vuln_nov08_win.nasl 464 2008-11-12 12:52:23Z nov $
#
# VLC Media Player Multiple Stack-Based BOF Vulnerabilities - Nov08 (Win)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800132);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5032", "CVE-2008-5036");
  script_bugtraq_id(32125);
  script_name("VLC Media Player Multiple Stack-Based BOF Vulnerabilities - Nov08 (Win)");
  desc = "

  Overview: This host is installed with VLC Media Player and is prone to
  Multiple Stack-Based Buffer Overflow Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused while parsing,
  - header of an invalid CUE image file related to modules/access/vcd/cdrom.c.
  - an invalid RealText(rt) subtitle file related to the ParseRealText function
    in modules/demux/subtitle.c.

  Impact: Successful exploitation allows attackers to execute arbitrary code
  within the context of the VLC media player by tricking a user into opening
  a specially crafted file or can even crash an affected application.

  Impact Level: Application

  Affected Software/OS:
  VLC media player 0.5.0 through 0.9.5 on Windows (Any).

  Fix: Upgrade to 0.9.6, or
  Apply the available patch from below link,
  http://git.videolan.org/?p=vlc.git;a=commitdiff;h=e3cef651125701a2e33a8d75b815b3e39681a447
  http://git.videolan.org/?p=vlc.git;a=commitdiff;h=5f63f1562d43f32331006c2c1a61742de031b84d

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://www.videolan.org/security/sa0810.html
  http://www.trapkit.de/advisories/TKADV2008-011.txt
  http://www.trapkit.de/advisories/TKADV2008-012.txt

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

vlcVer = registry_get_sz(item:"Version", key:"SOFTWARE\VideoLAN\VLC");
if(!vlcVer){
  exit(0);
}

# Check for VLC Media Player Version 0.5.0 to 0.9.5
if(version_in_range(version:vlcVer, test_version:"0.5.0", test_version2:"0.9.5")){
  security_hole(0);
}
