#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# This script is released under the GNU GPLv2


if(description)
{
 script_id(14294);
 script_bugtraq_id(8265);
 script_version ("$Revision: 8045 $");
 script_tag(name:"risk_factor", value:"Medium");
 script_xref(name:"OSVDB", value:"2243");
 name = "PhpGroupWare unspecified remote file include vulnerability";

 script_name(name);
 
 desc = "
The remote host seems to be running PhpGroupWare, is a multi-user groupware 
suite written in PHP.

This version is prone to a vulnerability that may permit remote attackers, 
without prior authentication, to include and execute malicious PHP scripts. 
Remote users may influence URI variables to include a malicious PHP script 
on a remote system, it is possible to cause arbitrary PHP code to be executed. 

Solution : Update to version 0.9.14.006 or newer

See also: http://www.phpgroupware.org/

Risk factor : Medium";

 script_description(desc);
 
 summary = "Checks for PhpGroupWare version";
 
 script_summary(summary);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("phpgroupware_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

kb = get_kb_item("www/" + port + "/phpGroupWare");
if (! kb ) exit(0);

matches = eregmatch(pattern:"(.*) under (.*)", string:kb);
if ( ereg(pattern:"^0\.([0-8]\.|9\.([0-9]\.|1[0-3]\.|14\.0*[0-5]([^0-9]|$)))", string:matches[1]) )
		security_warning(port);
