#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if(description)
{
  script_id(11929);
  script_version ("$Revision: 7540 $");
  script_tag(name:"risk_factor", value:"None");
 
  script_name( "SAP DB detection");
 
  desc = "
Synopsis :

SAP is listening on the remote port.

Description :

SAP/DB vserver, an ERP software,  is running on the remote
port.

Please make sure that you applied the last patches, as a 
buffer overflow attack has been published against it.

Solution : 

Make sure to be running version 7.4.03.30 or newer.

If this service is not needed, disable it or filter incoming traffic
to this port.

Risk factor : 

None";

# In fact, the overflow is against niserver (on port 7269)

  script_description(desc);
 
  summary = "Detect SAP DB vserver";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright("This script is Copyright (C) 2003 Michel Arboi");
  script_family("Service detection");
  script_dependencie("find_service.nes", "http_version.nasl");
  script_require_ports(7210);	# Services/unknown?
  exit(0);
}

include("misc_func.inc");
##include("dump.inc");

port = 7210;
if ( ! get_port_state(port) ) exit(0);


r = hex2raw(s:	"51000000035b00000100000000000000" +
		"000004005100000000023900040b0000" +
		"d03f0000d03f00000040000070000000" +
		"4e455353555320202020202020202020" +
		"0849323335333300097064626d73727600");

s = open_sock_tcp(port);
if ( ! s ) exit(0);
send(socket: s, data: r);

r2 = recv(socket: s, length: 64);

##dump(dtitle: "SAP", ddata: r2);

if (substr(r2, 0, 6) == hex2raw(s: "40000000035c00"))
{
  security_note(port);
  register_service(port: port, proto: "sap_db_vserver");
}


