///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __LAMMPS_BINARY_DUMP_PARSER_H
#define __LAMMPS_BINARY_DUMP_PARSER_H

#include <core/Core.h>
#include "LAMMPSDumpParser.h"

namespace AtomViz {

/**
 * \brief Parser class that can read LAMMPS dump files (binary format).
 *
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT LAMMPSBinaryDumpParser : public LAMMPSDumpParser
{
public:

	/// \brief Constructs a new instance of this class.
	/// \param isLoading Specifies whether the object's data fields will be initialized from the
	///                  data stored in a scene file after the instance has been created.
	LAMMPSBinaryDumpParser(bool isLoading = false);

protected:

	// from MultiFileParser:

	/// \brief Scans an atoms file for the time step frames contained therein.
	virtual bool scanFileForTimeSteps(const QString& filepath, bool suppressDialogs = false);

	/// \brief Parses the atomic data of a single time step.
	virtual EvaluationStatus loadTimeStep(AtomsObject* destination, int movieFrame, const QString& filename, streampos byteOffset, int lineNumber, bool suppressDialogs);

	// from AbstractFileColumnParser:

	/// \brief Parses the header of the given file and returns the number of data columns contained in the file.
	virtual bool inspectFileHeader(const QString& filename, int& numberOfColumns, QStringList& columnNames);

private:

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(LAMMPSBinaryDumpParser)
};

};	// End of namespace AtomViz

#endif // __LAMMPS_BINARY_DUMP_PARSER_H
