# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class GalleryImageFragment(Resource):
    """Represents an image from the Azure Marketplace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param is_enabled: Indicates whether this gallery image is enabled.
    :type is_enabled: bool
    :param is_override: Indicates whether this gallery has been overridden for
     this lab account
    :type is_override: bool
    :param is_plan_authorized: Indicates if the plan has been authorized for
     programmatic deployment.
    :type is_plan_authorized: bool
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'is_override': {'key': 'properties.isOverride', 'type': 'bool'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, is_enabled: bool=None, is_override: bool=None, is_plan_authorized: bool=None, provisioning_state: str=None, unique_identifier: str=None, **kwargs) -> None:
        super(GalleryImageFragment, self).__init__(location=location, tags=tags, **kwargs)
        self.is_enabled = is_enabled
        self.is_override = is_override
        self.is_plan_authorized = is_plan_authorized
        self.provisioning_state = provisioning_state
        self.unique_identifier = unique_identifier
