# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Compute(Model):
    """Machine Learning compute object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AKS, AmlCompute, VirtualMachine, HDInsight, DataFactory,
    Databricks, DataLakeAnalytics

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AKS', 'AmlCompute': 'AmlCompute', 'VirtualMachine': 'VirtualMachine', 'HDInsight': 'HDInsight', 'DataFactory': 'DataFactory', 'Databricks': 'Databricks', 'DataLakeAnalytics': 'DataLakeAnalytics'}
    }

    def __init__(self, **kwargs):
        super(Compute, self).__init__(**kwargs)
        self.compute_location = kwargs.get('compute_location', None)
        self.provisioning_state = None
        self.description = kwargs.get('description', None)
        self.created_on = None
        self.modified_on = None
        self.resource_id = kwargs.get('resource_id', None)
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.compute_type = None


class AKS(Compute):
    """A Machine Learning compute based on AKS.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param properties: AKS properties
    :type properties: ~azure.mgmt.machinelearningservices.models.AKSProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AKSProperties'},
    }

    def __init__(self, **kwargs):
        super(AKS, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.compute_type = 'AKS'


class ComputeSecrets(Model):
    """Secrets related to a Machine Learning compute. Might differ for every type
    of compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AksComputeSecrets, VirtualMachineSecrets,
    DatabricksComputeSecrets

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AksComputeSecrets', 'VirtualMachine': 'VirtualMachineSecrets', 'Databricks': 'DatabricksComputeSecrets'}
    }

    def __init__(self, **kwargs):
        super(ComputeSecrets, self).__init__(**kwargs)
        self.compute_type = None


class AksComputeSecrets(ComputeSecrets):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param user_kube_config: Content of kubeconfig file that can be used to
     connect to the Kubernetes cluster.
    :type user_kube_config: str
    :param admin_kube_config: Content of kubeconfig file that can be used to
     connect to the Kubernetes cluster.
    :type admin_kube_config: str
    :param image_pull_secret_name: Image registry pull secret.
    :type image_pull_secret_name: str
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AksComputeSecrets, self).__init__(**kwargs)
        self.user_kube_config = kwargs.get('user_kube_config', None)
        self.admin_kube_config = kwargs.get('admin_kube_config', None)
        self.image_pull_secret_name = kwargs.get('image_pull_secret_name', None)
        self.compute_type = 'AKS'


class AksNetworkingConfiguration(Model):
    """Advance configuration for AKS networking.

    :param subnet_id: Virtual network subnet resource ID the compute nodes
     belong to
    :type subnet_id: str
    :param service_cidr: A CIDR notation IP range from which to assign service
     cluster IPs. It must not overlap with any Subnet IP ranges.
    :type service_cidr: str
    :param dns_service_ip: An IP address assigned to the Kubernetes DNS
     service. It must be within the Kubernetes service address range specified
     in serviceCidr.
    :type dns_service_ip: str
    :param docker_bridge_cidr: A CIDR notation IP range assigned to the Docker
     bridge network. It must not overlap with any Subnet IP ranges or the
     Kubernetes service address range.
    :type docker_bridge_cidr: str
    """

    _validation = {
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AksNetworkingConfiguration, self).__init__(**kwargs)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.service_cidr = kwargs.get('service_cidr', None)
        self.dns_service_ip = kwargs.get('dns_service_ip', None)
        self.docker_bridge_cidr = kwargs.get('docker_bridge_cidr', None)


class AKSProperties(Model):
    """AKS properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param cluster_fqdn: Cluster full qualified domain name
    :type cluster_fqdn: str
    :ivar system_services: System services
    :vartype system_services:
     list[~azure.mgmt.machinelearningservices.models.SystemService]
    :param agent_count: Number of agents
    :type agent_count: int
    :param agent_vm_size: Agent virtual machine size
    :type agent_vm_size: str
    :param ssl_configuration: SSL configuration
    :type ssl_configuration:
     ~azure.mgmt.machinelearningservices.models.SslConfiguration
    :param aks_networking_configuration: AKS networking configuration for vnet
    :type aks_networking_configuration:
     ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
    """

    _validation = {
        'system_services': {'readonly': True},
        'agent_count': {'minimum': 1},
    }

    _attribute_map = {
        'cluster_fqdn': {'key': 'clusterFqdn', 'type': 'str'},
        'system_services': {'key': 'systemServices', 'type': '[SystemService]'},
        'agent_count': {'key': 'agentCount', 'type': 'int'},
        'agent_vm_size': {'key': 'agentVMSize', 'type': 'str'},
        'ssl_configuration': {'key': 'sslConfiguration', 'type': 'SslConfiguration'},
        'aks_networking_configuration': {'key': 'aksNetworkingConfiguration', 'type': 'AksNetworkingConfiguration'},
    }

    def __init__(self, **kwargs):
        super(AKSProperties, self).__init__(**kwargs)
        self.cluster_fqdn = kwargs.get('cluster_fqdn', None)
        self.system_services = None
        self.agent_count = kwargs.get('agent_count', None)
        self.agent_vm_size = kwargs.get('agent_vm_size', None)
        self.ssl_configuration = kwargs.get('ssl_configuration', None)
        self.aks_networking_configuration = kwargs.get('aks_networking_configuration', None)


class AmlCompute(Compute):
    """An Azure Machine Learning compute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param properties: AML Compute properties
    :type properties:
     ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AmlComputeProperties'},
    }

    def __init__(self, **kwargs):
        super(AmlCompute, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.compute_type = 'AmlCompute'


class AmlComputeNodeInformation(Model):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar node_id: Node ID. ID of the compute node.
    :vartype node_id: str
    :ivar ip_address: IP address. Public IP address of the compute node.
    :vartype ip_address: str
    :ivar port: Port. SSH port number of the node.
    :vartype port: float
    """

    _validation = {
        'node_id': {'readonly': True},
        'ip_address': {'readonly': True},
        'port': {'readonly': True},
    }

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(AmlComputeNodeInformation, self).__init__(**kwargs)
        self.node_id = None
        self.ip_address = None
        self.port = None


class ComputeNodesInformation(Model):
    """Compute nodes information related to a Machine Learning compute. Might
    differ for every type of compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmlComputeNodesInformation

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The continuation token.
    :vartype next_link: str
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    """

    _validation = {
        'next_link': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AmlCompute': 'AmlComputeNodesInformation'}
    }

    def __init__(self, **kwargs):
        super(ComputeNodesInformation, self).__init__(**kwargs)
        self.next_link = None
        self.compute_type = None


class AmlComputeNodesInformation(ComputeNodesInformation):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The continuation token.
    :vartype next_link: str
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :ivar nodes: The collection of returned AmlCompute nodes details.
    :vartype nodes:
     list[~azure.mgmt.machinelearningservices.models.AmlComputeNodeInformation]
    """

    _validation = {
        'next_link': {'readonly': True},
        'compute_type': {'required': True},
        'nodes': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'nodes': {'key': 'nodes', 'type': '[AmlComputeNodeInformation]'},
    }

    def __init__(self, **kwargs):
        super(AmlComputeNodesInformation, self).__init__(**kwargs)
        self.nodes = None
        self.compute_type = 'AmlCompute'


class AmlComputeProperties(Model):
    """AML Compute properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param vm_size: Virtual Machine Size
    :type vm_size: str
    :param vm_priority: Virtual Machine priority. Possible values include:
     'Dedicated', 'LowPriority'
    :type vm_priority: str or
     ~azure.mgmt.machinelearningservices.models.VmPriority
    :param scale_settings: Scale settings for AML Compute
    :type scale_settings:
     ~azure.mgmt.machinelearningservices.models.ScaleSettings
    :param user_account_credentials: User account credentials. Credentials for
     an administrator user account that will be created on each compute node.
    :type user_account_credentials:
     ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
    :param subnet: Subnet. Virtual network subnet resource ID the compute
     nodes belong to.
    :type subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar allocation_state: Allocation state. Allocation state of the compute.
     Possible values are: steady - Indicates that the compute is not resizing.
     There are no changes to the number of compute nodes in the compute in
     progress. A compute enters this state when it is created and when no
     operations are being performed on the compute to change the number of
     compute nodes. resizing - Indicates that the compute is resizing; that is,
     compute nodes are being added to or removed from the compute. Possible
     values include: 'Steady', 'Resizing'
    :vartype allocation_state: str or
     ~azure.mgmt.machinelearningservices.models.AllocationState
    :ivar allocation_state_transition_time: Allocation state transition time.
     The time at which the compute entered its current allocation state.
    :vartype allocation_state_transition_time: datetime
    :ivar errors: Errors. Collection of errors encountered by various compute
     nodes during node setup.
    :vartype errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar current_node_count: Current node count. The number of compute nodes
     currently assigned to the compute.
    :vartype current_node_count: int
    :ivar target_node_count: Target node count. The target number of compute
     nodes for the compute. If the allocationState is resizing, this property
     denotes the target node count for the ongoing resize operation. If the
     allocationState is steady, this property denotes the target node count for
     the previous resize operation.
    :vartype target_node_count: int
    :ivar node_state_counts: Node state counts. Counts of various node states
     on the compute.
    :vartype node_state_counts:
     ~azure.mgmt.machinelearningservices.models.NodeStateCounts
    """

    _validation = {
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'errors': {'readonly': True},
        'current_node_count': {'readonly': True},
        'target_node_count': {'readonly': True},
        'node_state_counts': {'readonly': True},
    }

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'vm_priority': {'key': 'vmPriority', 'type': 'str'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'ScaleSettings'},
        'user_account_credentials': {'key': 'userAccountCredentials', 'type': 'UserAccountCredentials'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'allocation_state': {'key': 'allocationState', 'type': 'str'},
        'allocation_state_transition_time': {'key': 'allocationStateTransitionTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[MachineLearningServiceError]'},
        'current_node_count': {'key': 'currentNodeCount', 'type': 'int'},
        'target_node_count': {'key': 'targetNodeCount', 'type': 'int'},
        'node_state_counts': {'key': 'nodeStateCounts', 'type': 'NodeStateCounts'},
    }

    def __init__(self, **kwargs):
        super(AmlComputeProperties, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)
        self.vm_priority = kwargs.get('vm_priority', None)
        self.scale_settings = kwargs.get('scale_settings', None)
        self.user_account_credentials = kwargs.get('user_account_credentials', None)
        self.subnet = kwargs.get('subnet', None)
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.errors = None
        self.current_node_count = None
        self.target_node_count = None
        self.node_state_counts = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ClusterUpdateParameters(Model):
    """AmlCompute update parameters.

    :param scale_settings: Scale settings. Desired scale settings for the
     amlCompute.
    :type scale_settings:
     ~azure.mgmt.machinelearningservices.models.ScaleSettings
    """

    _attribute_map = {
        'scale_settings': {'key': 'properties.scaleSettings', 'type': 'ScaleSettings'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpdateParameters, self).__init__(**kwargs)
        self.scale_settings = kwargs.get('scale_settings', None)


class Resource(Model):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'identity': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.identity = None
        self.location = kwargs.get('location', None)
        self.type = None
        self.tags = kwargs.get('tags', None)


class ComputeResource(Resource):
    """Machine Learning compute object wrapped into ARM resource envelope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param properties: Compute properties
    :type properties: ~azure.mgmt.machinelearningservices.models.Compute
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'identity': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'Compute'},
    }

    def __init__(self, **kwargs):
        super(ComputeResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class Databricks(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param properties:
    :type properties:
     ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DatabricksProperties'},
    }

    def __init__(self, **kwargs):
        super(Databricks, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.compute_type = 'Databricks'


class DatabricksComputeSecrets(ComputeSecrets):
    """Secrets related to a Machine Learning compute based on Databricks.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param databricks_access_token: access token for databricks account.
    :type databricks_access_token: str
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabricksComputeSecrets, self).__init__(**kwargs)
        self.databricks_access_token = kwargs.get('databricks_access_token', None)
        self.compute_type = 'Databricks'


class DatabricksProperties(Model):
    """DatabricksProperties.

    :param databricks_access_token: Databricks access token
    :type databricks_access_token: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabricksProperties, self).__init__(**kwargs)
        self.databricks_access_token = kwargs.get('databricks_access_token', None)


class DataFactory(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataFactory, self).__init__(**kwargs)
        self.compute_type = 'DataFactory'


class DataLakeAnalytics(Compute):
    """A DataLakeAnalytics compute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param properties:
    :type properties:
     ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataLakeAnalyticsProperties'},
    }

    def __init__(self, **kwargs):
        super(DataLakeAnalytics, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.compute_type = 'DataLakeAnalytics'


class DataLakeAnalyticsProperties(Model):
    """DataLakeAnalyticsProperties.

    :param data_lake_store_account_name: DataLake Store Account Name
    :type data_lake_store_account_name: str
    """

    _attribute_map = {
        'data_lake_store_account_name': {'key': 'dataLakeStoreAccountName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataLakeAnalyticsProperties, self).__init__(**kwargs)
        self.data_lake_store_account_name = kwargs.get('data_lake_store_account_name', None)


class ErrorDetail(Model):
    """Error detail information.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ErrorResponse(Model):
    """Error response information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar details: An array of error detail objects.
    :vartype details:
     list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class HDInsight(Compute):
    """A HDInsight compute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param properties:
    :type properties:
     ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'HDInsightProperties'},
    }

    def __init__(self, **kwargs):
        super(HDInsight, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.compute_type = 'HDInsight'


class HDInsightProperties(Model):
    """HDInsightProperties.

    :param ssh_port: Port open for ssh connections on the master node of the
     cluster.
    :type ssh_port: int
    :param address: Public IP address of the master node of the cluster.
    :type address: str
    :param administrator_account: Admin credentials for master node of the
     cluster
    :type administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(self, **kwargs):
        super(HDInsightProperties, self).__init__(**kwargs)
        self.ssh_port = kwargs.get('ssh_port', None)
        self.address = kwargs.get('address', None)
        self.administrator_account = kwargs.get('administrator_account', None)


class Identity(Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. Possible values include: 'SystemAssigned'
    :type type: str or
     ~azure.mgmt.machinelearningservices.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
    }

    def __init__(self, **kwargs):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class ListWorkspaceKeysResult(Model):
    """ListWorkspaceKeysResult.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    :ivar user_storage_resource_id:
    :vartype user_storage_resource_id: str
    :ivar app_insights_instrumentation_key:
    :vartype app_insights_instrumentation_key: str
    :ivar container_registry_credentials:
    :vartype container_registry_credentials:
     ~azure.mgmt.machinelearningservices.models.RegistryListCredentialsResult
    """

    _validation = {
        'user_storage_key': {'readonly': True},
        'user_storage_resource_id': {'readonly': True},
        'app_insights_instrumentation_key': {'readonly': True},
        'container_registry_credentials': {'readonly': True},
    }

    _attribute_map = {
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
        'user_storage_resource_id': {'key': 'userStorageResourceId', 'type': 'str'},
        'app_insights_instrumentation_key': {'key': 'appInsightsInstrumentationKey', 'type': 'str'},
        'container_registry_credentials': {'key': 'containerRegistryCredentials', 'type': 'RegistryListCredentialsResult'},
    }

    def __init__(self, **kwargs):
        super(ListWorkspaceKeysResult, self).__init__(**kwargs)
        self.user_storage_key = None
        self.user_storage_resource_id = None
        self.app_insights_instrumentation_key = None
        self.container_registry_credentials = None


class MachineLearningServiceError(Model):
    """Wrapper for error response to follow ARM guidelines.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error: The error response.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorResponse
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, **kwargs):
        super(MachineLearningServiceError, self).__init__(**kwargs)
        self.error = None


class MachineLearningServiceErrorException(HttpOperationError):
    """Server responsed with exception of type: 'MachineLearningServiceError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(MachineLearningServiceErrorException, self).__init__(deserialize, response, 'MachineLearningServiceError', *args)


class NodeStateCounts(Model):
    """Counts of various compute node states on the amlCompute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar idle_node_count: Idle node count. Number of compute nodes in idle
     state.
    :vartype idle_node_count: int
    :ivar running_node_count: Running node count. Number of compute nodes
     which are running jobs.
    :vartype running_node_count: int
    :ivar preparing_node_count: Preparing node count. Number of compute nodes
     which are being prepared.
    :vartype preparing_node_count: int
    :ivar unusable_node_count: Unusable node count. Number of compute nodes
     which are in unusable state.
    :vartype unusable_node_count: int
    :ivar leaving_node_count: Leaving node count. Number of compute nodes
     which are leaving the amlCompute.
    :vartype leaving_node_count: int
    :ivar preempted_node_count: Preempted node count. Number of compute nodes
     which are in preempted state.
    :vartype preempted_node_count: int
    """

    _validation = {
        'idle_node_count': {'readonly': True},
        'running_node_count': {'readonly': True},
        'preparing_node_count': {'readonly': True},
        'unusable_node_count': {'readonly': True},
        'leaving_node_count': {'readonly': True},
        'preempted_node_count': {'readonly': True},
    }

    _attribute_map = {
        'idle_node_count': {'key': 'idleNodeCount', 'type': 'int'},
        'running_node_count': {'key': 'runningNodeCount', 'type': 'int'},
        'preparing_node_count': {'key': 'preparingNodeCount', 'type': 'int'},
        'unusable_node_count': {'key': 'unusableNodeCount', 'type': 'int'},
        'leaving_node_count': {'key': 'leavingNodeCount', 'type': 'int'},
        'preempted_node_count': {'key': 'preemptedNodeCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(NodeStateCounts, self).__init__(**kwargs)
        self.idle_node_count = None
        self.running_node_count = None
        self.preparing_node_count = None
        self.unusable_node_count = None
        self.leaving_node_count = None
        self.preempted_node_count = None


class Operation(Model):
    """Azure Machine Learning workspace REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: Display name of operation
    :type display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """Display name of operation.

    :param provider: The resource provider name:
     Microsoft.MachineLearningExperimentation
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that users can perform.
    :type operation: str
    :param description: The description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class Password(Model):
    """Password.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Password, self).__init__(**kwargs)
        self.name = None
        self.value = None


class RegistryListCredentialsResult(Model):
    """RegistryListCredentialsResult.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location:
    :vartype location: str
    :ivar username:
    :vartype username: str
    :param passwords:
    :type passwords: list[~azure.mgmt.machinelearningservices.models.Password]
    """

    _validation = {
        'location': {'readonly': True},
        'username': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[Password]'},
    }

    def __init__(self, **kwargs):
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.location = None
        self.username = None
        self.passwords = kwargs.get('passwords', None)


class ResourceId(Model):
    """Represents a resource ID. For example, for a subnet, it is the resource URL
    for the subnet.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the resource
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceId, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ScaleSettings(Model):
    """scale settings for AML Compute.

    All required parameters must be populated in order to send to Azure.

    :param max_node_count: Required. Max number of nodes to use
    :type max_node_count: int
    :param min_node_count: Min number of nodes to use. Default value: 0 .
    :type min_node_count: int
    :param node_idle_time_before_scale_down: Node Idle Time before scaling
     down amlCompute
    :type node_idle_time_before_scale_down: timedelta
    """

    _validation = {
        'max_node_count': {'required': True},
    }

    _attribute_map = {
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'node_idle_time_before_scale_down': {'key': 'nodeIdleTimeBeforeScaleDown', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(ScaleSettings, self).__init__(**kwargs)
        self.max_node_count = kwargs.get('max_node_count', None)
        self.min_node_count = kwargs.get('min_node_count', 0)
        self.node_idle_time_before_scale_down = kwargs.get('node_idle_time_before_scale_down', None)


class ServicePrincipalCredentials(Model):
    """Service principal credentials.

    All required parameters must be populated in order to send to Azure.

    :param client_id: Required. Client Id
    :type client_id: str
    :param client_secret: Required. Client secret
    :type client_secret: str
    """

    _validation = {
        'client_id': {'required': True},
        'client_secret': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServicePrincipalCredentials, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class SslConfiguration(Model):
    """The ssl configuration for scoring.

    :param status: Enable or disable ssl for scoring. Possible values include:
     'Disabled', 'Enabled'
    :type status: str or ~azure.mgmt.machinelearningservices.models.enum
    :param cert: Cert data
    :type cert: str
    :param key: Key data
    :type key: str
    :param cname: CNAME of the cert
    :type cname: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'cert': {'key': 'cert', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'cname': {'key': 'cname', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SslConfiguration, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.cert = kwargs.get('cert', None)
        self.key = kwargs.get('key', None)
        self.cname = kwargs.get('cname', None)


class SystemService(Model):
    """A system service running on a compute.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar system_service_type: The type of this system service.
    :vartype system_service_type: str
    :ivar public_ip_address: Public IP address
    :vartype public_ip_address: str
    :ivar version: The version for this type.
    :vartype version: str
    """

    _validation = {
        'system_service_type': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'system_service_type': {'key': 'systemServiceType', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SystemService, self).__init__(**kwargs)
        self.system_service_type = None
        self.public_ip_address = None
        self.version = None


class Usage(Model):
    """Describes AML Resource Usage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar unit: An enum describing the unit of usage measurement. Possible
     values include: 'Count'
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.UsageUnit
    :ivar current_value: The current usage of the resource.
    :vartype current_value: long
    :ivar limit: The maximum permitted usage of the resource.
    :vartype limit: long
    :ivar name: The name of the type of usage.
    :vartype name: ~azure.mgmt.machinelearningservices.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(self, **kwargs):
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageName(Model):
    """The Usage Names.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class UserAccountCredentials(Model):
    """Settings for user account that gets created on each on the nodes of a
    compute.

    All required parameters must be populated in order to send to Azure.

    :param admin_user_name: Required. User name. Name of the administrator
     user account which can be used to SSH to nodes.
    :type admin_user_name: str
    :param admin_user_ssh_public_key: SSH public key. SSH public key of the
     administrator user account.
    :type admin_user_ssh_public_key: str
    :param admin_user_password: Password. Password of the administrator user
     account.
    :type admin_user_password: str
    """

    _validation = {
        'admin_user_name': {'required': True},
    }

    _attribute_map = {
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'admin_user_ssh_public_key': {'key': 'adminUserSshPublicKey', 'type': 'str'},
        'admin_user_password': {'key': 'adminUserPassword', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserAccountCredentials, self).__init__(**kwargs)
        self.admin_user_name = kwargs.get('admin_user_name', None)
        self.admin_user_ssh_public_key = kwargs.get('admin_user_ssh_public_key', None)
        self.admin_user_password = kwargs.get('admin_user_password', None)


class VirtualMachine(Compute):
    """A Machine Learning compute based on Azure Virtual Machines.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_location: Location for the underlying compute
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values
     are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible
     values include: 'Unknown', 'Updating', 'Creating', 'Deleting',
     'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: datetime
    :param resource_id: ARM resource id of the underlying compute
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned
     by user and brought from outside if true, or machine learning service
     provisioned it if false.
    :vartype is_attached_compute: bool
    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param properties:
    :type properties:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VirtualMachineProperties'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachine, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.compute_type = 'VirtualMachine'


class VirtualMachineProperties(Model):
    """VirtualMachineProperties.

    :param virtual_machine_size: Virtual Machine size
    :type virtual_machine_size: str
    :param ssh_port: Port open for ssh connections.
    :type ssh_port: int
    :param address: Public IP address of the virtual machine.
    :type address: str
    :param administrator_account: Admin credentials for virtual machine
    :type administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        'virtual_machine_size': {'key': 'virtualMachineSize', 'type': 'str'},
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineProperties, self).__init__(**kwargs)
        self.virtual_machine_size = kwargs.get('virtual_machine_size', None)
        self.ssh_port = kwargs.get('ssh_port', None)
        self.address = kwargs.get('address', None)
        self.administrator_account = kwargs.get('administrator_account', None)


class VirtualMachineSecrets(ComputeSecrets):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. Constant filled by server.
    :type compute_type: str
    :param administrator_account: Admin credentials for virtual machine.
    :type administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineSecrets, self).__init__(**kwargs)
        self.administrator_account = kwargs.get('administrator_account', None)
        self.compute_type = 'VirtualMachine'


class VirtualMachineSize(Model):
    """Describes the properties of a VM size.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Virtual Machine size name. The name of the virtual machine
     size.
    :vartype name: str
    :ivar family: Virtual Machine family name. The family name of the virtual
     machine size.
    :vartype family: str
    :ivar v_cp_us: Number of vPUs. The number of vCPUs supported by the
     virtual machine size.
    :vartype v_cp_us: int
    :ivar os_vhd_size_mb: OS VHD Disk size. The OS VHD disk size, in MB,
     allowed by the virtual machine size.
    :vartype os_vhd_size_mb: int
    :ivar max_resource_volume_mb: Resource volume size. The resource volume
     size, in MB, allowed by the virtual machine size.
    :vartype max_resource_volume_mb: int
    :ivar memory_gb: Memory size. The amount of memory, in GB, supported by
     the virtual machine size.
    :vartype memory_gb: float
    :ivar low_priority_capable: Low priority capable. Specifies if the virtual
     machine size supports low priority VMs.
    :vartype low_priority_capable: bool
    :ivar premium_io: Premium IO supported. Specifies if the virtual machine
     size supports premium IO.
    :vartype premium_io: bool
    """

    _validation = {
        'name': {'readonly': True},
        'family': {'readonly': True},
        'v_cp_us': {'readonly': True},
        'os_vhd_size_mb': {'readonly': True},
        'max_resource_volume_mb': {'readonly': True},
        'memory_gb': {'readonly': True},
        'low_priority_capable': {'readonly': True},
        'premium_io': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'v_cp_us': {'key': 'vCPUs', 'type': 'int'},
        'os_vhd_size_mb': {'key': 'osVhdSizeMB', 'type': 'int'},
        'max_resource_volume_mb': {'key': 'maxResourceVolumeMB', 'type': 'int'},
        'memory_gb': {'key': 'memoryGB', 'type': 'float'},
        'low_priority_capable': {'key': 'lowPriorityCapable', 'type': 'bool'},
        'premium_io': {'key': 'premiumIO', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineSize, self).__init__(**kwargs)
        self.name = None
        self.family = None
        self.v_cp_us = None
        self.os_vhd_size_mb = None
        self.max_resource_volume_mb = None
        self.memory_gb = None
        self.low_priority_capable = None
        self.premium_io = None


class VirtualMachineSizeListResult(Model):
    """The List Virtual Machine size operation response.

    :param aml_compute: The list of virtual machine sizes supported by
     AmlCompute.
    :type aml_compute:
     list[~azure.mgmt.machinelearningservices.models.VirtualMachineSize]
    """

    _attribute_map = {
        'aml_compute': {'key': 'amlCompute', 'type': '[VirtualMachineSize]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineSizeListResult, self).__init__(**kwargs)
        self.aml_compute = kwargs.get('aml_compute', None)


class VirtualMachineSshCredentials(Model):
    """Admin credentials for virtual machine.

    :param username: Username of admin account
    :type username: str
    :param password: Password of admin account
    :type password: str
    :param public_key_data: Public key data
    :type public_key_data: str
    :param private_key_data: Private key data
    :type private_key_data: str
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'public_key_data': {'key': 'publicKeyData', 'type': 'str'},
        'private_key_data': {'key': 'privateKeyData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineSshCredentials, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.public_key_data = kwargs.get('public_key_data', None)
        self.private_key_data = kwargs.get('private_key_data', None)


class Workspace(Resource):
    """An object that represents a machine learning workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :ivar workspace_id: The immutable id associated with this workspace.
    :vartype workspace_id: str
    :param description: The description of this workspace.
    :type description: str
    :param friendly_name: The friendly name for this workspace. This name in
     mutable
    :type friendly_name: str
    :ivar creation_time: The creation time of the machine learning workspace
     in ISO8601 format.
    :vartype creation_time: datetime
    :param key_vault: ARM id of the key vault associated with this workspace.
     This cannot be changed once the workspace has been created
    :type key_vault: str
    :param application_insights: ARM id of the application insights associated
     with this workspace. This cannot be changed once the workspace has been
     created
    :type application_insights: str
    :param container_registry: ARM id of the container registry associated
     with this workspace. This cannot be changed once the workspace has been
     created
    :type container_registry: str
    :param storage_account: ARM id of the storage account associated with this
     workspace. This cannot be changed once the workspace has been created
    :type storage_account: str
    :param discovery_url: Url for the discovery service to identify regional
     endpoints for machine learning experimentation services
    :type discovery_url: str
    :ivar provisioning_state: The current deployment state of workspace
     resource. The provisioningState is to indicate states for resource
     provisioning. Possible values include: 'Unknown', 'Updating', 'Creating',
     'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'identity': {'readonly': True},
        'type': {'readonly': True},
        'workspace_id': {'readonly': True},
        'creation_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'str'},
        'application_insights': {'key': 'properties.applicationInsights', 'type': 'str'},
        'container_registry': {'key': 'properties.containerRegistry', 'type': 'str'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'str'},
        'discovery_url': {'key': 'properties.discoveryUrl', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Workspace, self).__init__(**kwargs)
        self.workspace_id = None
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.creation_time = None
        self.key_vault = kwargs.get('key_vault', None)
        self.application_insights = kwargs.get('application_insights', None)
        self.container_registry = kwargs.get('container_registry', None)
        self.storage_account = kwargs.get('storage_account', None)
        self.discovery_url = kwargs.get('discovery_url', None)
        self.provisioning_state = None


class WorkspaceUpdateParameters(Model):
    """The parameters for updating a machine learning workspace.

    :param tags: The resource tags for the machine learning workspace.
    :type tags: dict[str, str]
    :param description: The description of this workspace.
    :type description: str
    :param friendly_name: The friendly name for this workspace.
    :type friendly_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkspaceUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
