# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DiskPoolTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SKU of the VM host part of the Disk Pool deployment."""

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class IscsiTargetAclMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ACL mode for iSCSI Target."""

    DYNAMIC = "Dynamic"
    STATIC = "Static"


class OperationalStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operational status of the resource."""

    INVALID = "Invalid"
    UNKNOWN = "Unknown"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    UPDATING = "Updating"
    RUNNING = "Running"
    STOPPED = "Stopped"
    STOPPED_DEALLOCATED_ = "Stopped (deallocated)"


class ProvisioningStates(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the iSCSI Target."""

    INVALID = "Invalid"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PENDING = "Pending"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"


class ResourceSkuRestrictionsReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for restriction."""

    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"


class ResourceSkuRestrictionsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of restrictions."""

    LOCATION = "Location"
    ZONE = "Zone"
