## Development
This project is managed using [Poetry](https://poetry.eustace.io).
Development requires Python 3.7+.

* If you want to take advantage of the default VSCode integration, then first
  configure Poetry to make its virtual environment in the repository:
  ```
  poetry config virtualenvs.in-project true
  ```
* After cloning the repository, activate the tooling:
  ```
  poetry install
  poetry run pre-commit install
  ```
* Run unit tests:
  ```
  poetry run pytest --cov
  ```
* Render documentation:
  ```
  pipx install mkdocs
  pipx runpip mkdocs install -r docs/requirements.txt
  mkdocs serve
  ```
