/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef MSGHISTORY_H
#define MSGHISTORY_H

#include <QObject>
#include <QByteArray>

class Message;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/

class MsgHistory
{
  private:
    Message** m_msgs;
    quint32   m_msgsNum;
    quint32   m_msgsMaxNum;
    quint16   m_allocStep;

    mutable QByteArray m_allMsgs;

  public:
    MsgHistory ();
    ~MsgHistory ();

    void       addMsg(Message* msg);
    void       fromByteArray(const QByteArray &);
    Message*   msg(qint32 n);
    quint32    size() const {return m_msgsNum;}
    const QByteArray & toByteArray(qint32) const;
};

#endif
