/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef TREEITEM_H
#define TREEITEM_H

#include <QList>
#include <QVariant>
#include <QVector>
/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class TreeItem
{
  private:
    QMap< int, QList<QVariant> > m_data;

    TreeItem*        m_parent;
    QList<TreeItem*> m_children;
    QString          m_name;
    QList<int>       m_hiddenColumns;
    QVector<int>     m_columns;

    static int m_sortingOrder;
    static int m_sortingColumn;

  public:
    TreeItem(const QList<QVariant> &data, TreeItem *parent = 0, QString = "");
    virtual ~TreeItem();

    int visibleCols(bool, int) const;

    const TreeItem* const child(int row) const;
    void appendChild(TreeItem* child);
    int childCount() const;
    int columnCount() const;
    int row() const;
    virtual QVariant data(int column, int role = Qt::DisplayRole, bool = 0) const;
    TreeItem *parent() const {return m_parent;}

    QList<TreeItem*>* children(){return &m_children;}
    const QString& name() const {return m_name;}
    void setParent(TreeItem* parent){m_parent = parent;}
    void setData  (const QList<QVariant> &data, int role = Qt::DisplayRole);
    void setData  (int column, const QVariant &data, int role = Qt::DisplayRole);

    QList<TreeItem*> takeChildren();
    void deleteChild(TreeItem*);

//     void insertColumn(int after, const QVariant&);
    void hideColumn  (int column);
    void showColumn  (int column);

    /// returns real number of column with visible number @param column
    int realColumn(int column) const;

    static void setSortingOrder(int theValue){m_sortingOrder = theValue;}
    static int sortingOrder() {return m_sortingOrder;}

    static void setSortingColumn(int theValue){m_sortingColumn = theValue;}
    static int sortingColumn() {return m_sortingColumn;}

    virtual void sortChildren(int column, Qt::SortOrder order);
    static bool LessThan(TreeItem* i1, TreeItem* i2);
};

#endif
