% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindrcpp-package.R
\docType{package}
\name{bindrcpp-package}
\alias{bindrcpp}
\alias{bindrcpp-package}
\title{bindrcpp: An 'Rcpp' Interface to Active Bindings}
\description{
Provides an easy way to fill an environment with active bindings
that call a C++ function.
}
\details{
Use \code{LinkingTo: bindrcpp} in \code{DESCRIPTION} and
\code{#include <bindrcpp.h>} in your C++ headers and/or modules to access the
C++ functions provided by this package:
\itemize{
\item \code{create_env_string()} creates an environment with active bindings, with
names given as a character vector.  Access of these bindings triggers a
call to a C++ function with a fixed signature (\code{GETTER_FUNC_STRING});
this call contains the name of the binding (as character) and an arbitrary
payload (\code{PAYLOAD}, essentially a wrapped \code{void*}).
\item \code{create_env_symbol()} is similar, the callback function accepts the name of
the binding as symbol instead of character (\code{GETTER_FUNC_SYMBOL}).
\item \code{populate_env_string()} and \code{populate_env_symbol()} populate an existing
environment instead of creating a new one.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/krlmlr/bindrcpp}
  \item \url{https://krlmlr.github.io/bindrcpp}
  \item Report bugs at \url{https://github.com/krlmlr/bindrcpp/issues}
}

}
\author{
\strong{Maintainer}: Kirill Müller \email{krlmlr+r@mailbox.org}

Other contributors:
\itemize{
  \item RStudio [copyright holder]
}

}
