% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_subsetBy.R
\name{by-subset}
\alias{by-subset}
\alias{subset_by}
\alias{subsetBy}
\title{Finds subsets of a dataframe which is split by variables in
a formula.}
\usage{
subset_by(data, formula, subset, select, drop = FALSE, join = TRUE, ...)

subsetBy(
  formula,
  subset,
  data = parent.frame(),
  select,
  drop = FALSE,
  join = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{formula}{A right hand sided formula or a character vector of
variables to split by.}

\item{subset}{logical expression indicating elements or rows to
keep: missing values are taken as false.}

\item{select}{expression, indicating columns to select from a data
frame.}

\item{drop}{passed on to \code{[} indexing operator.}

\item{join}{If FALSE the result is a list of data frames (as
defined by 'formula'); if TRUE one data frame is returned.}

\item{\dots}{further arguments to be passed to or from other methods.}
}
\value{
A data frame.
}
\description{
A data frame is split by a formula into groups. Then
subsets are found within each group, and the result is
collected into a data frame.
}
\examples{

data(dietox)
subsetBy(~Evit, Weight < mean(Weight), data=dietox)
}
\seealso{
\code{\link{splitBy}}, \code{\link{split_by}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\concept{byfunction}
\keyword{utilities}
