% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-metrics.R
\name{str_metrics}
\alias{str_metrics}
\title{Get font metrics for a string.}
\usage{
str_metrics(
  x,
  fontname = "sans",
  fontsize = 12,
  bold = FALSE,
  italic = FALSE,
  fontfile = ""
)
}
\arguments{
\item{x}{Character vector of strings to measure (only the first element is used).}

\item{fontname}{Font name.}

\item{fontsize}{Font size in points.}

\item{bold, italic}{Is text bold/italic?}

\item{fontfile}{Path to a font file. If empty, the font is
resolved by name via \code{systemfonts}.}
}
\value{
A named numeric vector with elements \code{width},
\code{ascent} and \code{descent} (unit is points).
}
\description{
Compute the width, ascent and descent of a single
string in points using Cairo text measurement.
}
\note{
This function will be deprecated in a future release.
Use \code{\link[=strings_sizes]{strings_sizes()}} instead.
}
\examples{
str_metrics("Hello World!")
}
\seealso{
Other functions for font metrics: 
\code{\link{m_str_extents}()},
\code{\link{strings_sizes}()}
}
\concept{functions for font metrics}
\keyword{internal}
