% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skip_scope.R
\name{skip_scope}
\alias{skip_scope}
\title{Exclude a function from find_scope}
\usage{
skip_scope(fun)
}
\arguments{
\item{fun}{a function to tag}
}
\value{
The \code{fun} function with the \code{skipscope} attribute set to TRUE.
}
\description{
In the course of work it will often be the case that
one would like to create a new condition function, such
such as for specific errors or warning.  These should
not be included in the scope when inferred.  The natural
solution would be to include the scope in every call to
condition or have it inferred in each function definition.
This however, gets very tedious.
}
\details{
The \code{skip_scope} function tags a function as one that should be
excluded from consideration when determining scope via
\code{\link[=find_scope]{find_scope()}}.
}
\examples{
new_msg <- function(where=find_scope()){
    "Hello from" \%<<\% where
}
new_postcard <- function(msg){
    greeting <- new_msg()
    paste0(greeting, '\n\n', msg)
}

cat(new_postcard("Not all is well"), '\n')
new_msg <- skip_scope(new_msg)

cat(new_postcard("Now all is well"))
}
