#! /bin/sh

# Test generation of XLSX tables

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue

TMPFILE=$(mktemp --suffix .zip)

. tests/inputs/test1.domain.net-template.env

${INPUT_SCRIPT} action=template format=xlsx \
    | perl -e 'while( <> ) { $. < 5 ? print STDERR $_ : print $_ }' \
    > ${TMPFILE}
xlsx2csv -s 0 ${TMPFILE} | tr -d "\r"

rm -f ${TMPFILE}
