"use strict";

function validate_all_fields( form ) {
    var inputs = document.getElementsByTagName( 'input' );

    var all_validates = true;
    for( var i = 0; i < inputs.length; i++ ) {
        var validates = validate_input( inputs[i].getAttribute( 'name' ) );
        if( !validates ) {
            all_validates = false;
        }
    }

    if( !all_validates ) {
        alert( 'Cannot submit, there are invalid form fields. ' +
               'Please make sure that all data is entered correctly. ' );
    }
    return all_validates;
}

function validate_int( name ) {
    var inputs = document.getElementsByName( name );
    var regexp = /^(-\d)?\d*$/;
    var all_validates = true;

    for( var i = 0; i < inputs.length; i++ ) {
        var max_value = inputs[i].getAttribute( 'data-max-value' );
        if( regexp.exec( inputs[i].value ) == null ) {
            inputs[i].className = 'invalid';
            inputs[i].nextElementSibling.innerHTML = 'Invalid integer.';
            all_validates = false;
        } else if( inputs[i].value != '' &&
                   max_value != null &&
                   Math.abs( inputs[i].value ) > max_value ) {
            inputs[i].className = 'invalid';
            inputs[i].nextElementSibling.innerHTML =
                'Absolute value of the field cannot exceed ' +
                max_value + '.';
            all_validates = false;
        } else {
            inputs[i].className = '';
            inputs[i].nextElementSibling.innerHTML = '';
        }
    }

    return all_validates;
}

function validate_float( name ) {
    var inputs = document.getElementsByName( name );
    var regexp = /^(-?\d+(\.\d+)?([eE][-+]?\d+)?)?$/;
    var all_validates = true;

    for( var i = 0; i < inputs.length; i++ ) {
        if( regexp.exec( inputs[i].value ) == null ) {
            inputs[i].className = 'invalid';
            inputs[i].nextElementSibling.innerHTML =
                'Invalid floating point number (e.g. 12.34).';
            all_validates = false;
        } else {
            inputs[i].className = '';
            inputs[i].nextElementSibling.innerHTML = '';
        }
    }

    return all_validates;
}

function validate_string( name ) {
    var inputs = document.getElementsByName( name );
    var all_validates = true;

    for( var i = 0; i < inputs.length; i++ ) {
        var messages = [];

        var length = inputs[i].getAttribute( 'data-max-length' );
        if( length != null && inputs[i].value.length > length ) {
            messages.push( 'Input too long: maximum ' + length +
                           ' symbols allowed.' );
        }

        var validation_regex = inputs[i].getAttribute( 'data-validation-regex' );
        if( validation_regex != null ) {
            var regexp = new RegExp( '^(' + validation_regex + ')?$' );
            if( regexp.exec( inputs[i].value ) == null ) {
                messages.push( 'Does not match regular expression \'^' +
                               validation_regex + '$\'.' );
            }
        }

        if( messages.length > 0 ) {
            inputs[i].className = 'invalid';
            inputs[i].nextElementSibling.innerHTML = messages.join(' ');
            all_validates = false;
        } else {
            inputs[i].className = '';
            inputs[i].nextElementSibling.innerHTML = '';
        }
    }

    return all_validates;
}

function validate_unsigned_int( name ) {
    var inputs = document.getElementsByName( name );
    var regexp = /^\d*$/;
    var all_validates = true;

    for( var i = 0; i < inputs.length; i++ ) {
        if( regexp.exec( inputs[i].value ) == null ) {
            inputs[i].className = 'invalid';
            inputs[i].nextElementSibling.innerHTML = 'Invalid unsigned integer.';
            all_validates = false;
        } else {
            inputs[i].className = '';
            inputs[i].nextElementSibling.innerHTML = '';
        }
    }

    return all_validates;
}

function validate_input( name ) {
    var inputs = document.getElementsByName( name );

    if( inputs.length == 0 ) {
        return true;
    }

    var validation_type = inputs[0].getAttribute( 'data-validation-type' );

    switch( validation_type ) {
        case 'int':
            return validate_int( name );
            break;
        case 'float':
            return validate_float( name );
            break;
        case 'string':
            return validate_string( name );
            break;
        default:
            return true;
    }
}

function validate_and_submit( form ) {
    if( validate_all_fields( form ) ) {
        /* The following piece of code disables the submit buttons,
         * however Firefox (at least) seems to be unable to send the
         * button's name and value to the recipient...
         var inputs = document.getElementsByTagName( 'input' );
         for( var i = 0; i < inputs.length; i++ ) {
            if( inputs[i].getAttribute( 'type' ) == 'submit' ) {
                inputs[i].disabled = true;
            }
         }
         */
        return true;
    } else {
        return false;
    }
}
