#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "runge_kutta_ssp.icc"
#include "burgers.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  Float tf = 0.5, cfl = 1;
  size_t p    = (argc > 3) ? atoi(argv[3]) : pmax;
  size_t nmax = (argc > 4) ? atoi(argv[4]) : floor(1+tf/(cfl*omega.hmin()));
  Float delta_t = tf/nmax;
  form_option_type fopt;
  fopt.invert = true;
  trial u (Xh); test v (Xh);
  form inv_m = integrate (u*v, fopt);
  vector<field> uh(p+1, field(Xh,0));
  uh[0] = interpolate (Xh, u_init);
  branch even("t","u");
  dout << catchmark("delta_t") << delta_t << endl
       << even(0,uh[0]);
  for (size_t n = 1; n <= nmax; ++n) {
    for (size_t i = 1; i <= p; ++i) {
      uh[i] = 0;
      for (size_t j = 0; j < i; ++j) {
        field lh
         = integrate (dot(compose(f,uh[j]),grad_h(v)))
         + integrate ("internal_sides",
             compose (phi, normal(), inner(uh[j]), outer(uh[j]))*jump(v))
         + integrate ("boundary",
             compose (phi, normal(), uh[j], g)*v);
        uh[i] += alpha[p][i][j]*uh[j] - delta_t*beta[p][i][j]*(inv_m*lh);
      }
    }
    uh[0] = uh[p];
    dout << even(n*delta_t,uh[0]);
  }
}
