///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// sparse vector = STL map of type T
//	    + linear algebra methods
//
// author: Pierre.Saramito@imag.fr
//
// date: 14 january 1997
//
# include "rheolef/avec.h"
# include "rheolef/iorheo.h"
# include "rheolef/outml.h"
using namespace rheolef;
using namespace std;

namespace rheolef { 
template <class T>
ostream& operator << (ostream& s, const avec<T>& sx)
{
    iorheo::flag_type fmt = iorheo::flags(s) & iorheo::format_field;

    if (fmt [iorheo::ml]) {

        print_matlab (s, sx);
        return s;
    }
    if (fmt [iorheo::rheo]) {
        fatal_macro ("format `rheo' not implemented (fmt="<<fmt<<")");
    }
    fatal_macro ("format not implemented (fmt="<<fmt<<")");
    return s;
}
// =====================[ INSTANCIATION IN LIBRARY ]=============================
template ostream& operator << (ostream& s, const avec<Float>& sx);

}// namespace rheolef
