% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension.R
\docType{methods}
\name{dbNextResult}
\alias{dbMoreResults}
\alias{dbMoreResults,MySQLConnection-method}
\alias{dbNextResult}
\alias{dbNextResult,MySQLConnection-method}
\title{Fetch next result set from an SQL script or stored procedure (experimental)}
\usage{
dbNextResult(con, ...)

\S4method{dbNextResult}{MySQLConnection}(con, ...)

dbMoreResults(con, ...)

\S4method{dbMoreResults}{MySQLConnection}(con, ...)
}
\arguments{
\item{con}{a connection object (see \code{\link[DBI]{dbConnect}}).}

\item{...}{any additional arguments to be passed to the dispatched method}
}
\value{
\code{dbNextResult} returns a result set or \code{NULL}.

  \code{dbMoreResults} returns a logical specifying whether or not there are
  additional result sets to process in the connection.
}
\description{
SQL scripts (i.e., multiple SQL statements separated by ';') and stored
procedures oftentimes generate multiple result sets.  These generic
functions provide a means to process them sequentially. \code{dbNextResult}
fetches the next result from the sequence of pending results sets;
\code{dbMoreResults} returns a logical to indicate whether there are
additional results to process.
}
\examples{
if (mysqlHasDefault()) {
con <- dbConnect(RMySQL::MySQL(), dbname = "test", client.flag = CLIENT_MULTI_STATEMENTS)
dbWriteTable(con, "mtcars", datasets::mtcars, overwrite = TRUE)

sql <- "SELECT cyl FROM mtcars LIMIT 5; SELECT vs FROM mtcars LIMIT 5"
rs1 <- dbSendQuery(con, sql)
dbFetch(rs1, n = -1)

if (dbMoreResults(con)) {
   rs2 <- dbNextResult(con)
   dbFetch(rs2, n = -1)
}

dbClearResult(rs1)
dbClearResult(rs2)
dbRemoveTable(con, "mtcars")
dbDisconnect(con)
}
}

