struct Version {
    name: &'static str,
}

impl sop::ops::Version<'_> for Version {
    fn frontend(&self) -> sop::Result<sop::ops::VersionInfo> {
        Ok(sop::ops::VersionInfo {
            name: self.name.into(),
            version: env!("CARGO_PKG_VERSION").into(),
        })
    }
    fn backend(&self) -> sop::Result<sop::ops::VersionInfo> {
        todo!()
    }
    fn extended(&self) -> sop::Result<String> {
        todo!()
    }
}

fn main() {
    #[cfg(any(feature = "cli", feature = "cliv"))]
    {
        #[allow(dead_code)]
        let outdir = std::env::var_os("CARGO_TARGET_DIR")
            .or(std::env::var_os("OUT_DIR"))
            .expect("cargo to set OUT_DIR");

        #[cfg(feature = "cli")]
        {
            sop::cli::write_shell_completions2(sop::cli::Variant::Full, "rsop", &outdir).unwrap();
            sop::cli::write_man_pages(
                sop::cli::Variant::Full,
                &Version { name: "rsop" },
                std::env::var_os("CARGO_PKG_AUTHORS")
                    .unwrap()
                    .to_str()
                    .unwrap(),
                &outdir,
            )
            .unwrap();
        }
        #[cfg(all(feature = "cliv", not(feature = "cli")))]
        {
            sop::cli::write_shell_completions2(sop::cli::Variant::Verification, "rsopv", &outdir)
                .unwrap();
            sop::cli::write_man_pages(
                sop::cli::Variant::Verification,
                &Version { name: "rsopv" },
                std::env::var_os("CARGO_PKG_AUTHORS")
                    .unwrap()
                    .to_str()
                    .unwrap(),
                &outdir,
            )
            .unwrap();
        }
    }
}
