// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Buffer, CompressionType, Encoding, File, NewlineType};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GtkSourceFileLoader")]
    pub struct FileLoader(Object<ffi::GtkSourceFileLoader, ffi::GtkSourceFileLoaderClass>);

    match fn {
        type_ => || ffi::gtk_source_file_loader_get_type(),
    }
}

impl FileLoader {
    #[doc(alias = "gtk_source_file_loader_new")]
    pub fn new(buffer: &impl IsA<Buffer>, file: &impl IsA<File>) -> FileLoader {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_source_file_loader_new(
                buffer.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_loader_new_from_stream")]
    #[doc(alias = "new_from_stream")]
    pub fn from_stream(
        buffer: &impl IsA<Buffer>,
        file: &impl IsA<File>,
        stream: &impl IsA<gio::InputStream>,
    ) -> FileLoader {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_source_file_loader_new_from_stream(
                buffer.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
                stream.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`FileLoader`] objects.
    ///
    /// This method returns an instance of [`FileLoaderBuilder`](crate::builders::FileLoaderBuilder) which can be used to create [`FileLoader`] objects.
    pub fn builder() -> FileLoaderBuilder {
        FileLoaderBuilder::new()
    }

    #[doc(alias = "gtk_source_file_loader_get_buffer")]
    #[doc(alias = "get_buffer")]
    pub fn buffer(&self) -> Buffer {
        unsafe {
            from_glib_none(ffi::gtk_source_file_loader_get_buffer(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_loader_get_compression_type")]
    #[doc(alias = "get_compression_type")]
    pub fn compression_type(&self) -> CompressionType {
        unsafe {
            from_glib(ffi::gtk_source_file_loader_get_compression_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_loader_get_encoding")]
    #[doc(alias = "get_encoding")]
    pub fn encoding(&self) -> Encoding {
        unsafe {
            from_glib_none(ffi::gtk_source_file_loader_get_encoding(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_loader_get_file")]
    #[doc(alias = "get_file")]
    pub fn file(&self) -> File {
        unsafe { from_glib_none(ffi::gtk_source_file_loader_get_file(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_file_loader_get_input_stream")]
    #[doc(alias = "get_input_stream")]
    #[doc(alias = "input-stream")]
    pub fn input_stream(&self) -> Option<gio::InputStream> {
        unsafe {
            from_glib_none(ffi::gtk_source_file_loader_get_input_stream(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_loader_get_location")]
    #[doc(alias = "get_location")]
    pub fn location(&self) -> Option<gio::File> {
        unsafe {
            from_glib_none(ffi::gtk_source_file_loader_get_location(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_loader_get_newline_type")]
    #[doc(alias = "get_newline_type")]
    pub fn newline_type(&self) -> NewlineType {
        unsafe {
            from_glib(ffi::gtk_source_file_loader_get_newline_type(
                self.to_glib_none().0,
            ))
        }
    }
}

impl Default for FileLoader {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`FileLoader`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FileLoaderBuilder {
    builder: glib::object::ObjectBuilder<'static, FileLoader>,
}

impl FileLoaderBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<Buffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn file(self, file: &impl IsA<File>) -> Self {
        Self {
            builder: self.builder.property("file", file.clone().upcast()),
        }
    }

    pub fn input_stream(self, input_stream: &impl IsA<gio::InputStream>) -> Self {
        Self {
            builder: self
                .builder
                .property("input-stream", input_stream.clone().upcast()),
        }
    }

    pub fn location(self, location: &impl IsA<gio::File>) -> Self {
        Self {
            builder: self.builder.property("location", location.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`FileLoader`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> FileLoader {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
