// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 1988-2010 - INRIA - Serge Steer
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//<-- CLI SHELL MODE -->
//
// <-- ENGLISH IMPOSED -->
//
// Elementary setbpt tests with scalar line number argument
// Order of the commands is important to guarantee
// the full coverage of the tests
delbpt(),dispbpt()   // should display no output
if execstr("delbpt(""foo1"",0)","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("delbpt(""foo1"",-3)","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("delbpt(""foo1"",3.2)","errcatch")<>9997 then pause,end   // should spit error 9997
setbpt("foo1"),dispbpt()   // set at line 1 (default)
setbpt("foo1",5),dispbpt()  // add another bpt to a macro that already has bpts, and that is the last one
setbpt("foo2",5),setbpt("foo2",8),dispbpt()  // add bpts to a new macro (will always be placed at the end)
setbpt("foo1",9),dispbpt()  // add another bpt to a macro that already has bpts, and that is NOT the last one
setbpt("foo1",5),dispbpt()  // check duplicates removal - line 5 should appear only once in foo1
setbpt("foo2",5),dispbpt()  // check duplicates removal - line 5 should appear only once in foo2

// More complicated setbpt tests with vector line number argument
// Order of the commands is important to guarantee
// the full coverage of the tests
delbpt(),dispbpt()   // should display no output
if execstr("setbpt(""foo1"",[1,0,5]) ","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("setbpt(""foo1"",[-3,2,7]) ","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("setbpt(""foo1"",[1,3.2]) ","errcatch")<>9997 then pause,end   // should spit error 9997
setbpt("foo1",[8,9]),dispbpt()    // add 2 bpts at once to a new macro
setbpt("foo1",5),setbpt("foo1",[2,3]),dispbpt()  // add further bpts to a macro that already has bpts, and that is the last one
setbpt("foo2",[5,8]),setbpt("foo2",7),dispbpt()  // add bpts to a new macro (will always be placed at the end)
setbpt("foo1",[10,15,20]),dispbpt()  // add bpts to a macro that already has bpts, and that is NOT the last one
setbpt("foo1",[50,50,50,60,50,80,60]),dispbpt()  // check duplicates removal in vector input, not the last macro - lines 50 and 60 should appear only once in foo1
setbpt("foo1",[9,5,8,100,3,2]),dispbpt()  // check duplicates removal wrt existing bpts, not the last macro - all lines should appear only once in foo1
setbpt("foo2",[50,50,50,60,50,80,60]),dispbpt()  // check duplicates removal in vector input, last macro - lines 50 and 60 should appear only once in foo1
setbpt("foo2",[9,5,8,100,7,2]),dispbpt()  // check duplicates removal wrt existing bpts, last macro - all lines should appear only once in foo2


// Elementary delbpt tests with scalar line number argument
// Order of the commands is important to guarantee
// the full coverage of the tests
delbpt(),dispbpt()   // should display no output
if execstr("delbpt(""foo1"",0)","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("delbpt(""foo1"",-3)","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("delbpt(""foo1"",3.2)","errcatch")<>9997 then pause,end   // should spit error 9997
delbpt("foo1"),dispbpt()   // should display no output
setbpt("foo1",[5,8,11]),delbpt("foo1"),dispbpt()   // should display no output
setbpt("foo1",[5,8,11]),setbpt("foo2",[55,88,111]),delbpt("foo1"),dispbpt()   // should display the 3 bpts for foo2 only
setbpt("foo1",[5,8,11]),setbpt("foo2",[55,88,111]),delbpt("foo2"),dispbpt()   // should display the 3 bpts for foo1 only
delbpt()
setbpt("foo1",5),delbpt("foo1",5),dispbpt()   // should display no output
setbpt("foo1",[5,6,8]),delbpt("foo1",5),dispbpt()    // lines 6 and 8 should appear only
setbpt("foo1",[5,10,11]),delbpt("foo1",10),dispbpt()    // lines 5, 6, 8 and 11 should appear only
delbpt("foo1",11),dispbpt()    // lines 5, 6 and 8 should appear only
setbpt("foo2",[20,21,22,23]),delbpt("foo1",6),dispbpt()    // lines 5 and 8 for foo1, and 20 to 23 for foo2
delbpt("foo2",21),dispbpt()    // lines 5, and 8 for foo1, and 20, 22, 23 for foo2

// More complicated delbpt tests with vector line number argument
// Order of the commands is important to guarantee
// the full coverage of the tests
delbpt(),dispbpt()   // should display no output
if execstr("delbpt(""foo1"",[1,0,5])","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("delbpt(""foo1"",[-3,2,7])","errcatch")<>9997 then pause,end   // should spit error 9997
if execstr("delbpt(""foo1"",[1,3.2])","errcatch")<>9997 then pause,end   // should spit error 9997
delbpt("foo1",[8,9]),dispbpt()   // should display no output
setbpt("foo1",[5,6,8,9]),delbpt("foo1",[8,5]),dispbpt()    // lines 6 and 9 should appear only
setbpt("foo1",[5,6,8,9]),delbpt("foo1",[8,5,8,8,6,5]),dispbpt()    // check duplicates removal in vector input - line 9 should appear only
setbpt("foo1",[5,6,8,9]),setbpt("foo2",[10,12,14,16,18]),delbpt("foo1",[8,5,8,10]),dispbpt()    // not the last macro, check duplicates removal in vector input - lines 6 and 9 should appear for foo1, plus all the 5 bpts for foo2
setbpt("foo1",[5,6,8,9]),setbpt("foo2",[10,12,14,16,18]),delbpt("foo1",[8,5,6,9]),dispbpt()    // remove all, not the last macro - should display no bpt for foo1, but all the 5 bpts for foo2
setbpt("foo1",[5,6,8,9]),setbpt("foo2",[10,12,14,16,18]),delbpt("foo2",[14,18,10,20]),dispbpt()    // last macro - should display all the 4 bpts for foo1, but only lines 12 and 16 for foo2
setbpt("foo1",[5,6,8,9]),setbpt("foo2",[10,12,14,16,18]),delbpt("foo2",[14,18,10,12,16]),dispbpt()    // remove all, last macro - should display all the 4 bpts for foo1, but no bpt for foo2


// non regression test for bug 2474
if execstr('for i=1;delbpt();end','errcatch')<>0 then pause,end

