/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "ags/engine/ac/global_view_frame.h"
#include "ags/shared/ac/common.h"
#include "ags/shared/ac/view.h"
#include "ags/shared/ac/game_setup_struct.h"
#include "ags/engine/debugging/debug_log.h"
#include "ags/engine/media/audio/audio_system.h"
#include "ags/globals.h"

namespace AGS3 {

void SetFrameSound(int vii, int loop, int frame, int sound) {
	if ((vii < 1) || (vii > _GP(game).numviews))
		quit("!SetFrameSound: invalid view number");
	vii--;

	if (loop >= _G(views)[vii].numLoops)
		quit("!SetFrameSound: invalid loop number");

	if (frame >= _G(views)[vii].loops[loop].numFrames)
		quit("!SetFrameSound: invalid frame number");

	if (sound < 1) {
		_G(views)[vii].loops[loop].frames[frame].sound = -1;
	} else {
		ScriptAudioClip *clip = GetAudioClipForOldStyleNumber(_GP(game), false, sound);
		if (clip == nullptr)
			quitprintf("!SetFrameSound: audio clip aSound%d not found", sound);

		_G(views)[vii].loops[loop].frames[frame].sound =
			_GP(game).IsLegacyAudioSystem() ? sound : clip->id;
		_G(views)[vii].loops[loop].frames[frame].audioclip = clip->id;
	}
}

} // namespace AGS3
