/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * AtFS -- Attribute Filesystem
 *
 * aflib.c -- Miscellaneous functions
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: aflib.c[7.0] Fri Jun 25 14:32:00 1993 andy@cs.tu-berlin.de frozen $
 */

#include "atfs.h"

/*================================================================
 *	af_retfsize
 *================================================================*/

EXPORT size_t af_retfsize (file)
     char *file;
{
  struct stat ibuf;
  
  if (stat (file, &ibuf) == -1)
    return ((size_t) 0);
  return (ibuf.st_size);
} /* af_retfsize */ 


/*=========================================================================
 *     af_cpfile -- copy files
 *=========================================================================*/

EXPORT int af_cpfile (source, size, dest)
     char *source;
     size_t size;
     char *dest;
{
  char            cont[BUFSIZ];
  register int    bufsiz = BUFSIZ;
  register FILE   *sfile, *dfile;
  
  if ((sfile = fopen (source, "r")) == (FILE *)0)
    return (ERROR);
  if ((dfile = fopen (dest, "w")) == (FILE *) 0) {
    /* try to remove file */
    unlink (dest);
    if ((dfile = fopen (dest, "w")) == (FILE *) 0) {
      fclose (sfile);
      return (ERROR);
    }
  }

  while (size > 0) {
    if (size >= BUFSIZ)
      size -= BUFSIZ;
    else {
      bufsiz = size;
      size = 0;
    }
    if (!fread (cont, sizeof(char), bufsiz, sfile)) {
      fclose (sfile);
      fclose (dfile);
      return (ERROR);
    }
    if (!fwrite (cont, sizeof(char), bufsiz, dfile)) {
      fclose (sfile);
      fclose (dfile);
      return (ERROR);
    }
  }

  fclose (sfile);
  fclose (dfile);
  return (AF_OK);
}

/*========================================================================
 * af_bsearch -- do binary search on ordered list of strings
 *               returns position (-1 if target not found)
 *========================================================================*/

EXPORT int af_bsearch (list, size, target)
     char **list;
     int  size;
     char *target;
{
  register int hi = size-1, lo=0, pos, res;

  pos = (hi+lo)/2;
  while (hi >= lo) {
    if ((res = strcmp (target, list[pos])) == 0)
      return (pos);
    else {	  
      if (res < 0)
	hi = pos - 1;
      else /* res > 0 */
	lo = pos + 1;
      pos = (hi+lo)/2;
    }
  }
  /* the target string was not found */
  return (ERROR);
}

