## Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with ShapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# Authors: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
#          Juergen Nickelsen (Juergen.Nickelsen@cs.tu-berlin.de)
#
# $Header: sfind.sh[6.0] Fri Jun 25 17:01:21 1993 andy@cs.tu-berlin.de frozen $
#

if [ $# -lt 1 ] ; then
  echo Usage: `basename $0` '[-comp|-subs]' directory '[command]' 1>&2
  exit 1
fi

objs=-subs			# may contain -comp or -subs
if [ $1 = -comp ] ; then
	objs=-comp
	shift
elif [ $1 = -subs ] ; then
	shift
fi

rootdir=$1 ; shift
curdir=`pwd`
cd $rootdir
subsystems=`shape -echo SUBSYSTEMS`
cd $curdir

for path in $subsystems ; do
  $0 $objs $rootdir/$path $*
done

if [ "$objs" = -subs ] ; then 	# operate on subsystems
  # we must do awful things to make sure sed doesn't get confused
  subspattern=`echo $rootdir | sed 's|/|\\\\/|g'`
  cmdline=`echo "$@" | sed 's/{}/'$subspattern'/g'`
  if [ "$cmdline" ] ; then
    cd $rootdir
    eval "$cmdline"
    cd $curdir
  else
    echo $rootdir
  fi
else				# operate on components
  cd $rootdir
  components=`shape -echo COMPONENTS`
  cd $curdir
  for comp in $components ; do
    subspattern=`echo $rootdir/$comp | sed 's|/|\\\\/|g'`
    cmdline=`echo "$@" | sed 's/{}/'$subspattern'/g'`
    if [ "$cmdline" ] ; then
      cd $rootdir
      eval "$cmdline"
      cd $curdir
    else
      echo $rootdir/$comp
    fi
  done
fi      

exit 0
