/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGADVICE_H
#define SKGADVICE_H
/** @file
 * This file defines classes SKGAdvice .
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <QString>
#include <QObject>
#include <QStringList>
#include <QMetaType>

#include "skgbasemodeler_export.h"

/**
* This class manages errors
*/
class SKGBASEMODELER_EXPORT SKGAdvice : public QObject
{
    Q_OBJECT
    /**
     * Priotity
     */
    Q_PROPERTY(int priority READ getPriority WRITE setPriority)
    /**
     * Unique identifier
     */
    Q_PROPERTY(QString uuid READ getUUID WRITE setUUID)
    /**
     * Short message
     */
    Q_PROPERTY(QString shortMessage READ getShortMessage WRITE setShortMessage)
    /**
     * Long message
     */
    Q_PROPERTY(QString longMessage READ getLongMessage WRITE setLongMessage)
    /**
     * Auto corrections
     */
    Q_PROPERTY(QStringList autoCorrections READ getAutoCorrections WRITE setAutoCorrections)
public:
    /**
    * Constructor
    */
    explicit SKGAdvice();

    /**
    * Copy constructor
    * @param iAdvice the advice to copy
    */
    SKGAdvice(const SKGAdvice& iAdvice);

    /**
    * Destructor
    */
    virtual ~SKGAdvice();

    /**
    * Operator affectation
    * @param iAdvice the advice to copy
    */
    SKGAdvice& operator= (const SKGAdvice& iAdvice);

public slots:
    /**
    * Set the unique identifier
    * @param iUUID the unique identifier
    */
    virtual void setUUID(const QString& iUUID);

    /**
    * Return the unique identifier
    * @return the unique identifier
    */
    virtual QString getUUID() const;

    /**
    * Set the priority
    * @param iPriority the priority
    */
    virtual void setPriority(int iPriority);

    /**
    * Return the priority
    * @return the priority
    */
    virtual int getPriority() const;

    /**
    * Set the short message
    * @param iMessage the short message
    */
    virtual void setShortMessage(const QString& iMessage);

    /**
    * Return the short message
    * @return the short message
    */
    virtual QString getShortMessage() const;

    /**
    * Set the long message
    * @param iMessage the long message
    */
    virtual void setLongMessage(const QString& iMessage);

    /**
    * Return the long message
    * @return the long message
    */
    virtual QString getLongMessage() const;

    /**
    * Set the auto corrections
    * @param iCorrections the auto corrections
    */
    virtual void setAutoCorrections(const QStringList&   iCorrections);

    /**
    * Return the auto corrections
    * @return the auto corrections
    */
    virtual QStringList getAutoCorrections() const;

private:
    /**
     * the unique identifier
     */
    QString m_uuid;

    /**
    * the priority
    */
    int m_priority;

    /**
     * the short message
     */
    QString m_shortMessage;

    /**
     * the short message
     */
    QString m_longMessage;

    /**
     * the list of auto corrections
     */
    QStringList m_autoCorrections;
};
/**
 * Declare the meta type
 */
Q_DECLARE_METATYPE(SKGAdvice)

/**
 * Declare the class
 */
Q_DECLARE_TYPEINFO(SKGAdvice, Q_MOVABLE_TYPE);

/**
 * the SKGAdviceList
 */
typedef QList<SKGAdvice> SKGAdviceList;
/**
 * Declare the meta type
 */
Q_DECLARE_METATYPE(QList<SKGAdvice>)
#endif  // SKGADVICE_H
