9.1 Live-Coding: Grundlagen

# Live-Coding

Inzwischen haben wir genug gelernt, nun können wir wirklich Spaß
haben.

In diesem Abschnitt nutzen wir alles, was wir bisher in diesem Tutorial 
gelernt haben und zeigen Dir, wie Du Deine Kompositionen live aufführen 
und in Performances verwandeln kannst. Dazu benötigen wir vor allem 
drei Zutaten:

* Die Fähigkeit, Code zu schreiben, der Töne erzeugt - CHECK!
* Die Fähigkeit, Funktionen zu schreiben - CHECK!
* Die Fähigkeit, (named) Threads zu verwenden - CHECK!

Ok, es kann also los gehen. Lass uns unsere ersten Sounds live coden. 
Zuerst brauchen wir eine Funktion, die den abzuspielenden Code enthält. 
Wir fangen ganz einfach an. Außerdem wollen wir diese Funktion in einer 
Schleife in einem Thread aufrufen:

```
define :my_loop do
  play 50
  sleep 1
end

in_thread(name: :looper) do
  loop do
    my_loop
  end
end
```

Wenn Dir das ein bisschen zu kompliziert aussieht, lies bitte noch 
einmal die Abschnitte über Funktionen und Threads durch. Wenn Du diese 
Dinge verstanden hast, wird es Dir nicht mehr sehr kompliziert 
vorkommen.

Wir haben hier eine Funktion, welche die Note 50 spielt und danach eine 
Schlagzeit lang schläft. Dann definieren wir einen benamten Thread, den
wir `:looper` nennen. Dieser ruft in einer Endlosschleife `my_loop` auf.

Wenn Du diesen Code ausführst, wirst Du immer und immer wieder die Note 
50 hören...

## Hochschalten

Jetzt geht es richtig los. Während der Code *noch läuft*, ändere die 50 
in eine andere Zahl, zum Beispiel 55, und drücke den `Ausführen`-Button 
erneut. Woah! Es hat sich verändert! Live!

Wir haben keine neue Ebene bekommen, da wir einen benannten Thread 
verwendet haben und es nur einen Thread pro Name geben kann. Der Ton hat 
sich geändert, weil wir die Funktion *umgeschrieben* haben. Wir haben 
also `:my_loop` eine veränderte Funktion verpasst. Der `:looper`-Thread
hat einfach diese veränderte Funktion aufgerufen.

Verändere die Funktion noch einmal, ändere die Note und die Pausenzeit. 
Wie wäre es damit, ein `use_synth`-Statement einzufügen?

Ändere die Funktion zum Beispiel in folgenden Code:

```
define :my_loop do
  use_synth :tb303
  play 50, release: 0.3
  sleep 0.25
end
```

Jetzt klingt es schon ganz interessant, wir können es aber noch ein 
bisschen aufpeppen. Anstatt immer wieder die gleiche Note zu spielen, 
versuche es einmal mit einem Akkord.

```
define :my_loop do
  use_synth :tb303
  play chord(:e3, :minor), release: 0.3
  sleep 0.5
end
```

Und wie wäre es damit, zufällige Töne des Akkords zu spielen:

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.3
  sleep 0.25
end
```

Oder einen zufälligen Cut-Off-Wert:

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

Und zum Schluss noch ein Schlagzeug dazu:

```
define :my_loop do
  use_synth :tb303
  sample :drum_bass_hard, rate: rrand(0.5, 2)
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

So langsam wird das hier alles viel spannender!

Bevor Du jetzt aufspringst und mit Funktionen und Threads live codest,
solltest Du lieber erst einmal eine Pause machen und das nächste 
Kapitel über den `live_loop` lesen. Denn dieser wird für immer
verändern, wie Du in Sonic Pi programmierst...
