8.3 Skale

# Skale

Sonic Pi posiada wsparcie dla szerokiego zakresu skal. 
Co powiesz na to aby zagrać C3 ze skali durowej?

```
play_pattern_timed scale(:c3, :major), 0.125, release: 0.1
```

Możemy nawet poprosić o więcej oktaw: 

```
play_pattern_timed scale(:c3, :major, num_octaves: 3), 0.125, release: 0.1
```

Co powiesz na wszystkie nuty w skali pentatonicznej (pentatonika)?

```
play_pattern_timed scale(:c3, :major_pentatonic, num_octaves: 3), 0.125, release: 0.1
```

## Losowe nuty

Akordy i skale są świetnym sposobem na ograniczenie wyboru losowego do 
czegoś sensownego. Spróbuj pobawić się z tym przykładem, który wybiera 
losowe nuty z akordu E3 moll: 

```
use_synth :tb303
loop do
  play choose(chord(:E3, :minor)), release: 0.3, cutoff: rrand(60, 120)
  sleep 0.25
end
```

Spróbuj poustawiać inne nazwy akordów oraz inne zakresy odcięcia (cutoff). 

## Odkrywanie Akordów i Skal

Aby zobaczyć jakie skale i akordy są wspierane przez Sonic Pi kliknij 
na przycisk Lang znajdujący się po lewej stronie tego samouczka, 
następnie z listy dostępnych API wybierz pozycję chord (akord) 
lub scale (skala). W informacjach znajdujących się w głównym panelu, 
przewiń w dół aż ujrzysz długą listę akordów lub skal (w zależności 
od tego na którą pozycję patrzysz).

Baw się i pamiętaj: błędów nie ma, sa tylko możliwości.
