3.5 部分的なサンプル

# 部分的なサンプル

このセクションでは、Sonic Piのサンプルの再生について私たちが探求してきたことをまとめます。
簡単にまとめてみましょう。

これまで、サンプルを再生する方法をみてきました。

```
sample :loop_amen
```

まず、サンプルのレート（速さ）を変更する方法を見つけて、このように半分の速度で再生してみました。

```
sample :loop_amen, rate: 0.5
```

次に、サンプルを徐々に大きくするフェードインを知りました。
（半分の速度でやってみましょう）

```
sample :loop_amen, rate: 0.5, attack: 1
```

また、`sustain:`に明確な値とアタックとリリースの両方の短い値を設定することで、
サンプルを打楽器のように使用する方法を見つけました。

```
sample :loop_amen, rate: 2, attack: 0.01, sustain: 0, release: 0.35
```

では、いつもサンプルの先頭から開始する必要はあるのでしょうか？
そして、いつもサンプルの最後まで終了する必要はあるのでしょうか？

## 開始点の選択

サンプルのどこからでも、好きな場所を選んで音を再生することが可能です。
0はサンプルの開始で、1は終了です。0.5はサンプルの途中です。
アーメンブレイクの最後の半分を再生してみましょう。

```
sample :loop_amen, start: 0.5
```

どのようにすればサンプルの最後の1/4を再生できますか？

```
sample :loop_amen, start: 0.75
```

## 終了点を選択する

同様に、サンプルの0から１の間の値を終了点として選ぶことができます。
アーメンブレイクの半分までで終わらせてみましょう。

```
sample :loop_amen, finish: 0.5
```

## 開始と終了の指定

もちろん、私たちは好きな部分を再生するために、これまでの開始と終了の２つを組み合わせることができます。
どのようにすれば真ん中あたりの短い場所だけを選べるのでしょうか？

```
sample :loop_amen, start: 0.4, finish: 0.6
```

もし、終了位置のあとを、開始位置として選ぶとどうなるでしょう？

```
sample :loop_amen, start: 0.6, finish: 0.4
```

かっこいい！！！逆再生になりますね！

## レートと組み合わせ

そして新しい機能として、すでに学んだ`rate:`と`start:`(開始)と`finish:`(終了)を使った部分再生を組み合わせることができます。

```
sample :loop_amen, start: 0.5, finish: 0.7, rate: 0.2
```

## エンベロープとの組み合わせ

そして、面白い結果を創りだすために、ADSRエンベロープと、いままでの全てを組み合わせることができます。

```
sample :loop_amen, start: 0.5, finish: 0.8, rate: -0.2, attack: 0.3, release: 1
```

今すぐ、サンプルとこれまでに紹介した楽しい内容を組み合わせて演奏してみましょう！

