8.2 Chords

# Chords

Sonic Pi has built-in support for chord names which will return
lists. Try it for yourself:

```
play chord(:E3, :minor)
```

Now, we're really getting somewhere. That looks a lot more pretty than
the raw lists (and is easier to read for other people). So what other
chords does Sonic Pi support? Well, a *lot*. Try some of these:

* `chord(:E3, :m7)`
* `chord(:E3, :minor)`
* `chord(:E3, :dim7)`
* `chord(:E3, :dom7)`

## Arpeggios

We can easily turn chords into arpeggios with the function
`play_pattern`:

```
play_pattern chord(:E3, :m7)
```

Ok, that's not so fun - it played it really slowly. `play_pattern` will
play each note in the list separated with a call to `sleep 1` between
each call to `play`. We can use another function `play_pattern_timed` to
specify our own timings and speed things up:

```
play_pattern_timed chord(:E3, :m7), 0.25
```

We can even pass a list of times which it will treat as a circle of
times:

```
play_pattern_timed chord(:E3, :m13), [0.25, 0.5]
```

This is the equivalent to:

```
play 52
sleep 0.25
play 55
sleep 0.5
play 59
sleep 0.25
play 62
sleep 0.5
play 66
sleep 0.25
play 69
sleep 0.5
play 73
```

Which would you prefer to write?
