[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::transform::spacer n 1]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Space insertation and removal}]
[require Tcl 8.6]
[require tcl::transform::core [opt 1]]
[require tcl::transform::spacer [opt 1]]
[description]
[para]

The [package tcl::transform::spacer] package provides a command
creating a channel transformation which adds spacing to the data
written to it, and removes such spacing from the data read from it.

[para] The internal [package TclOO] class implementing the transform
handler is a sub-class of the [package tcl::transform::core]
framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::transform::spacer] [arg chan] [arg n] [opt [arg space]]]

This command creates a spacer transformation on top of the channel
[arg chan] and returns its handle.

[para] The [arg space] character sequence will be added every [arg n]
bytes of data written, and on the read side the same is done in
reverse, removing the spacing. If [arg space] is not specified it
defaults to a single space character (ASCII 32).

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph virtchannel] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords spacing transformation {channel transformation}]
[keywords {virtual channel} {reflected channel} {tip 230}]
[manpage_end]
