
# Copyright (C) 2020-2022 Tommi Höynälänmaa

# This file is part of Theme-D-Intr.

# You can redistribute and/or modify this file under the terms of the
# GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.

# This file is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program. If not, see https://www.gnu.org/licenses/.


.PHONY: all clean

ifdef THEME_D_LIB_DIR
  MODULE_OPTION = -m ../..:$(THEME_D_LIB_DIR)
else
  MODULE_OPTION = -m ../..:
endif

PROGRAMS = run-demo

TARGETS = $(patsubst %,%.go,$(PROGRAMS))

GEN_NAME := "(intr-gtk3-examples theme-d-intr-demo _intr-imports)"
INTR_MODULE := "(intr-gtk3-examples theme-d-intr-demo _intr-imports-target)"

EXTRA_COMP_OPTIONS ?=
EXTRA_LINK_OPTIONS ?=

TDC := theme-d-compile

TDL := theme-d-link

GEN_INTF := generate-intr-interface
GEN_BODY := generate-intr-body
GEN_TM := generate-intr-target-module

all: $(TARGETS)

clean:
	-rm -f $(TARGETS) $(patsubst %,%.tcp,$(PROGRAMS))
	-rm -f *.tci
	-rm -f *.tcb
	-rm -f *.tcp
	-rm -f _intr-imports.tci _intr-imports.tcb \
	  _intr-imports.thi _intr-imports.thb _intr-imports-target.scm

#$(TARGETS) : %.go : %.tree-il
#	guild compile --from=tree-il -o $@ $<

# run-demo.tree-il: run-demo.tcp \
# 	  _intr-imports.tci _intr-imports.tcb _intr-imports-link.scm \
# 	  demo.tcb \
# 	  dialog.tcb panes.tcb sizegroup.tcb button-box.tcb \
# 	  list-store.tcb tree-store.tcb \
# 	  appwindow.tcb \
# 	  support.tcb
# 	$(TDL) -m ../..: -z _intr-imports-link.scm $(EXTRA_LINK_OPTIONS) \
# 	  --no-final-compilation --keep-intermediate -n $@ $<

# run-demo.tcp : _intr-imports.tci demo.tci \
# 	dialog.tci panes.tci sizegroup.tci button-box.tci \
# 	list-store.tci tree-store.tci \
# 	appwindow.tci \
# 	support.tci _intr-imports.tci

run-demo.go: run-demo.tcp \
	  _intr-imports.tci _intr-imports.tcb \
	  _intr-imports-target.scm \
	  demo.tcb dialog.tcb sizegroup.tcb button-box.tcb \
	  list-store.tcb tree-store.tcb panes.tcb appwindow.tcb \
	  support.tcb
	$(TDL) $(MODULE_OPTION) \
	  -x "(g-golf)" \
	  -x "(guile-theme-d-intr support)" \
	  -x "(guile-theme-d-intr support2-gtk3)" \
	  -x $(INTR_MODULE) \
	  --duplicates="merge-generics replace warn-override-core warn last" \
	  --extra-guild-options="" \
	  $(EXTRA_LINK_OPTIONS) \
	  -o $@ $<

run-demo.tree-il: run-demo.tcp \
	  _intr-imports.tci _intr-imports.tcb \
	  _intr-imports-target.scm \
	  demo.tcb dialog.tcb sizegroup.tcb button-box.tcb \
	  list-store.tcb tree-store.tcb panes.tcb appwindow.tcb \
	  support.tcb
	$(TDL) $(MODULE_OPTION) \
	  -x "(g-golf)" \
	  -x "(guile-theme-d-intr support)" \
	  -x "(guile-theme-d-intr support2-gtk3)" \
	  -x $(INTR_MODULE) \
	  --duplicates="merge-generics replace warn-override-core warn last" \
	  --extra-guild-options="" \
	  $(EXTRA_LINK_OPTIONS) \
	  --no-final-compilation --keep-intermediate -n $@ $<

MODULES = panes dialog sizegroup button-box list-store tree-store appwindow

run-demo.scm: run-demo.tcp \
	  _intr-imports.tci _intr-imports.tcb \
	  _intr-imports-target.scm \
	  demo.tcb dialog.tcb sizegroup.tcb button-box.tcb \
	  list-store.tcb tree-store.tcb appwindow.tcb \
	  support.tcb
	$(TDL) $(MODULE_OPTION) \
	  -x "(g-golf)" \
	  -x "(guile-theme-d-intr support)" \
	  -x "(guile-theme-d-intr support2-gtk3)" \
	  -x $(INTR_MODULE) \
	  --duplicates="merge-generics replace warn-override-core warn last" \
	  --extra-guild-options="" \
	  $(EXTRA_LINK_OPTIONS) \
	  -i guile --pretty-print \
	  --no-final-compilation --keep-intermediate -n $@ $<

run-demo.tcp : _intr-imports.tci demo.tci \
	panes.tci dialog.tci sizegroup.tci button-box.tci \
	list-store.tci tree-store.tci appwindow.tci \
	support.tci _intr-imports.tci

_intr-imports.thi: intr-imports.scm
	$(GEN_INTF) -m $(GEN_NAME)

_intr-imports.thb: intr-imports.scm
	$(GEN_BODY) -m $(GEN_NAME)

_intr-imports-target.scm: intr-imports.scm
	$(GEN_TM) -m $(INTR_MODULE)

%.tci: %.thi
	$(TDC) $(MODULE_OPTION) $(EXTRA_COMP_OPTIONS) $<

%.tcb: %.thb
	$(TDC) $(MODULE_OPTION) $(EXTRA_COMP_OPTIONS) $<

%.tcp: %.thp
	$(TDC) $(MODULE_OPTION) $(EXTRA_COMP_OPTIONS) $<

panes.tci : demo.tci support.tci

dialog.tci : demo.tci support.tci

sizegroup.tci : demo.tci support.tci

button-box.tci : demo.tci support.tci

list-store.tci : demo.tci support.tci

tree-store.tci : demo.tci support.tci

appwindow.tci : demo.tci support.tci
