/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.graphics.TrackPainter;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TrackObject;
import rene.zirkel.structures.Coordinates;

public class ObjectTracker
extends ObjectConstructor
implements TrackPainter,
Runnable,
Selector {
    PointObject PM;
    ConstructionObject O;
    ConstructionObject P;
    int PMax = 16;
    int PN;
    ConstructionObject[] PO = new ConstructionObject[this.PMax];
    Vector V = new Vector();
    Vector VPM = new Vector();
    Vector[] VO = new Vector[this.PMax];
    boolean Animate;
    boolean Paint;
    public boolean Interactive = true;
    boolean Other = false;
    ZirkelCanvas ZC;
    boolean Running = false;
    boolean Stopped = false;
    double da = 0.0;
    double oldx;
    double oldy;
    double X;
    double Y;
    double DX;
    double DY;
    double[] XO = new double[this.PMax];
    double[] YO = new double[this.PMax];
    double[] DXO = new double[this.PMax];
    double[] DYO = new double[this.PMax];
    int Omit = 1;
    public double StepSize = 5.0;

    public ObjectTracker() {
    }

    public ObjectTracker(ConstructionObject constructionObject, PointObject pointObject, ConstructionObject constructionObject2, ZirkelCanvas zirkelCanvas, boolean bl, boolean bl2, ConstructionObject[] constructionObjectArray) {
        this.P = constructionObject;
        this.PM = pointObject;
        this.O = constructionObject2;
        if (this.P != null && this.O != null && (this.PM != null || this.O instanceof ExpressionObject)) {
            this.Animate = bl;
            this.Paint = bl2;
            if (this.PM != null) {
                this.PM.project(this.O);
            }
            zirkelCanvas.validate();
            zirkelCanvas.repaint();
            this.showStatus(zirkelCanvas);
            this.PN = 0;
            for (int i = 0; i < constructionObjectArray.length && i < this.PMax && constructionObjectArray[i] != null; ++i) {
                this.PO[this.PN] = constructionObjectArray[i];
                this.VO[i] = new Vector();
                ++this.PN;
            }
        }
    }

    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        if (this.O == null) {
            if (constructionObject instanceof ExpressionObject && ((ExpressionObject)constructionObject).isSlider()) {
                return true;
            }
            if (constructionObject instanceof PrimitiveLineObject) {
                return true;
            }
            if (constructionObject instanceof PrimitiveCircleObject) {
                return true;
            }
            return constructionObject instanceof PointObject && ((PointObject)constructionObject).isPointOn();
        }
        if (!(constructionObject instanceof PointObject)) {
            return false;
        }
        if (!((MoveableObject)((Object)constructionObject)).moveable()) {
            return false;
        }
        if (this.O instanceof CircleObject && ((CircleObject)this.O).getP2() == constructionObject) {
            return true;
        }
        if (zirkelCanvas.depends(this.O, constructionObject)) {
            return false;
        }
        ConstructionObject constructionObject2 = ((PointObject)constructionObject).getBound();
        return constructionObject2 == null || constructionObject2 == this.O;
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        if (this.P == null) {
            this.P = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (this.P == null) {
                this.P = zirkelCanvas.selectLine(mouseEvent.getX(), mouseEvent.getY());
            }
            if (this.P != null) {
                this.P.setSelected(true);
                zirkelCanvas.repaint();
            }
            if (mouseEvent.isShiftDown()) {
                this.Other = true;
                this.PN = 0;
            } else {
                this.Other = false;
            }
            this.showStatus(zirkelCanvas);
        } else if (this.Other) {
            ConstructionObject constructionObject = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (constructionObject == null) {
                constructionObject = zirkelCanvas.selectLine(mouseEvent.getX(), mouseEvent.getY());
            }
            if (constructionObject != null) {
                constructionObject.setSelected(true);
                zirkelCanvas.repaint();
                this.PO[this.PN] = constructionObject;
                this.VO[this.PN] = new Vector();
                ++this.PN;
            }
            if (!mouseEvent.isShiftDown() || this.PN >= this.PMax) {
                this.Other = false;
            }
            this.showStatus(zirkelCanvas);
        } else if (this.O == null) {
            this.O = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
            if (this.O instanceof ExpressionObject) {
                zirkelCanvas.clearSelected();
                zirkelCanvas.clearIndicated();
                this.Animate = !mouseEvent.isShiftDown();
                this.Paint = true;
                this.compute(zirkelCanvas);
                this.ZC = zirkelCanvas;
                if (this.Animate) {
                    zirkelCanvas.validate();
                }
                zirkelCanvas.repaint();
            } else if (this.O instanceof PointObject && ((PointObject)this.O).isPointOn()) {
                this.PM = (PointObject)this.O;
                this.O = this.PM.getBound();
                zirkelCanvas.clearSelected();
                zirkelCanvas.clearIndicated();
                this.Animate = !mouseEvent.isShiftDown();
                this.Paint = true;
                this.compute(zirkelCanvas);
                this.ZC = zirkelCanvas;
                if (this.Animate) {
                    zirkelCanvas.validate();
                }
                zirkelCanvas.repaint();
            } else {
                if (this.O != null) {
                    this.O.setSelected(true);
                    zirkelCanvas.repaint();
                }
                this.showStatus(zirkelCanvas);
            }
        } else if (this.PM == null && !(this.O instanceof ExpressionObject)) {
            ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
            if (constructionObject == null) {
                return;
            }
            this.PM = (PointObject)constructionObject;
            zirkelCanvas.clearSelected();
            zirkelCanvas.clearIndicated();
            this.Animate = !mouseEvent.isShiftDown();
            this.Paint = true;
            this.compute(zirkelCanvas);
            this.ZC = zirkelCanvas;
            if (this.Animate) {
                zirkelCanvas.validate();
            }
            zirkelCanvas.repaint();
        } else if (!(mouseEvent.isControlDown() || mouseEvent.isShiftDown() || mouseEvent.isAltDown())) {
            if (!this.Running && this.Interactive && this.PM != null && this.PM.nearto(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas)) {
                this.Dragging = true;
                zirkelCanvas.getConstruction().shouldSwitch(true);
            } else if (this.Animate) {
                if (this.Paint) {
                    this.Paint = false;
                } else {
                    this.Animate = false;
                    this.Paint = true;
                    if (this.Running) {
                        this.stop();
                    }
                    this.showStatus(zirkelCanvas);
                }
            } else {
                if (this.Running) {
                    return;
                }
                this.Paint = true;
                this.Animate = true;
                this.compute(zirkelCanvas);
                zirkelCanvas.validate();
                zirkelCanvas.repaint();
                this.showStatus(zirkelCanvas);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        if (this.PM != null) {
            return;
        }
        if (this.P == null || this.Other) {
            zirkelCanvas.indicatePointsOrLines(mouseEvent.getX(), mouseEvent.getY());
        } else if (this.O == null) {
            zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
        } else {
            zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging || this.PM == null) {
            return;
        }
        double d2 = this.PM.getX();
        double d3 = this.PM.getY();
        this.PM.move(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
        zirkelCanvas.dovalidate();
        if (this.P.valid()) {
            zirkelCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging || this.PM == null) {
            return;
        }
        zirkelCanvas.getConstruction().shouldSwitch(false);
        this.Dragging = false;
        zirkelCanvas.validate();
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.clearSelected();
        if (this.Running) {
            this.stop();
        }
        this.PM = null;
        this.O = null;
        this.P = null;
        this.V = new Vector();
        this.PN = 0;
        for (int i = 0; i < this.PMax; ++i) {
            this.VO[i] = null;
        }
        zirkelCanvas.repaint();
        this.showStatus(zirkelCanvas);
        this.Omit = 1;
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P == null || this.Other) {
            zirkelCanvas.showStatus(Zirkel.name("message.objecttracker.select"));
        } else if (this.O == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.objecttracker.object"));
        } else if (this.PM == null && !(this.O instanceof ExpressionObject)) {
            zirkelCanvas.showStatus(Zirkel.name("message.objecttracker.selectpoint"));
        } else if (this.Running) {
            zirkelCanvas.showStatus(Zirkel.name("message.objecttracker.stop"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.objecttracker.start"));
        }
    }

    public Enumeration elements() {
        return this.V.elements();
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        double d2;
        double d3;
        double d4;
        double d5;
        Coordinates coordinates;
        if (!this.isComplete()) {
            return;
        }
        if (this.P == null || !this.Paint) {
            return;
        }
        Enumeration enumeration = this.V.elements();
        myGraphics.setColor(this.P);
        PolygonDrawer polygonDrawer = new PolygonDrawer(myGraphics, this.P);
        if (enumeration.hasMoreElements()) {
            coordinates = (Coordinates)enumeration.nextElement();
            d5 = zirkelCanvas.col(coordinates.X);
            d4 = zirkelCanvas.row(coordinates.Y);
            polygonDrawer.startPolygon(d5, d4);
            while (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                d3 = zirkelCanvas.col(coordinates.X);
                d2 = zirkelCanvas.row(coordinates.Y);
                if (Math.abs(d5 - d3) < 100.0 && Math.abs(d4 - d2) < 100.0) {
                    polygonDrawer.drawTo(d3, d2);
                } else {
                    polygonDrawer.finishPolygon();
                }
                d5 = d3;
                d4 = d2;
            }
            polygonDrawer.finishPolygon();
        }
        for (int i = 0; i < this.PN; ++i) {
            enumeration = this.VO[i].elements();
            myGraphics.setColor(this.PO[i]);
            polygonDrawer = new PolygonDrawer(myGraphics, this.PO[i]);
            if (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                d5 = zirkelCanvas.col(coordinates.X);
                d4 = zirkelCanvas.row(coordinates.Y);
                polygonDrawer.startPolygon(d5, d4);
                while (enumeration.hasMoreElements()) {
                    coordinates = (Coordinates)enumeration.nextElement();
                    d3 = zirkelCanvas.col(coordinates.X);
                    d2 = zirkelCanvas.row(coordinates.Y);
                    if (Math.abs(d5 - d3) < 100.0 && Math.abs(d4 - d2) < 100.0) {
                        polygonDrawer.drawTo(d3, d2);
                    } else {
                        polygonDrawer.finishPolygon();
                    }
                    d5 = d3;
                    d4 = d2;
                }
            }
            polygonDrawer.finishPolygon();
        }
    }

    public void validate(ZirkelCanvas zirkelCanvas) {
        if (!this.isComplete()) {
            return;
        }
        if (this.O instanceof ExpressionObject && !((ExpressionObject)this.O).isSlider()) {
            return;
        }
        if (this.Running) {
            return;
        }
        if (this.PM != null) {
            this.PM.project(this.O);
            this.oldx = this.PM.getX();
            this.oldy = this.PM.getY();
        } else if (this.O instanceof ExpressionObject) {
            this.oldx = ((ExpressionObject)this.O).getSliderPosition();
        }
        this.compute(zirkelCanvas);
        if (this.Animate) {
            this.ZC = zirkelCanvas;
            new Thread(this).start();
        } else {
            if (this.PM != null) {
                this.PM.move(this.oldx, this.oldy);
            }
            zirkelCanvas.dovalidate();
            zirkelCanvas.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(ZirkelCanvas zirkelCanvas) {
        if (!this.isComplete()) {
            return;
        }
        zirkelCanvas.getConstruction().clearSwitches();
        zirkelCanvas.getConstruction().shouldSwitch(true);
        Enumeration enumeration = this.VPM.elements();
        Enumeration enumeration2 = this.V.elements();
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl = false;
        Graphics graphics = this.ZC.getGraphics();
        while (enumeration.hasMoreElements()) {
            Coordinates coordinates = (Coordinates)enumeration.nextElement();
            Coordinates coordinates2 = (Coordinates)enumeration2.nextElement();
            if (this.PM == null && !(this.O instanceof ExpressionObject)) break;
            ZirkelCanvas zirkelCanvas2 = zirkelCanvas;
            synchronized (zirkelCanvas2) {
                if (this.PM != null) {
                    this.PM.move(coordinates.X, coordinates.Y);
                } else if (this.O instanceof ExpressionObject) {
                    ((ExpressionObject)this.O).setSliderPosition(coordinates.X);
                }
                if (!bl) {
                    zirkelCanvas.resetSum();
                    bl = true;
                }
            }
            zirkelCanvas.dovalidate();
            if (++n < this.Omit) continue;
            n = 0;
            if (zirkelCanvas.isInside(coordinates2.X, coordinates2.Y)) {
                if (this.P != null && this.P.valid()) {
                    this.ZC.paint(graphics);
                }
                try {
                    long l2 = System.currentTimeMillis();
                    int n2 = (int)(l2 - l);
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 > 50) {
                        n2 = 50;
                    }
                    Thread.sleep(50 - n2);
                    l = System.currentTimeMillis();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.Stopped) continue;
            break;
        }
        graphics.dispose();
        zirkelCanvas.getConstruction().shouldSwitch(false);
        zirkelCanvas.getConstruction().clearSwitches();
    }

    public ConstructionObject getObject() {
        return this.O;
    }

    double mod(double d2) {
        if (d2 >= Math.PI) {
            return d2 - Math.PI * 2;
        }
        if (d2 < -Math.PI) {
            return d2 + Math.PI * 2;
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.O instanceof ExpressionObject && !((ExpressionObject)this.O).isSlider()) {
            return;
        }
        if (this.V.size() == 0) {
            return;
        }
        if (!this.Animate) {
            return;
        }
        this.Running = true;
        this.Stopped = false;
        this.showStatus(this.ZC);
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (this.ZC.I == null);
        do {
            if (this.PM != null) {
                this.PM.move(this.oldx, this.oldy);
            } else if (this.O instanceof ExpressionObject) {
                ((ExpressionObject)this.O).setSliderPosition(this.oldx);
            }
            this.animate(this.ZC);
        } while (!this.Stopped);
        if (this.PM != null && !(this.O instanceof ExpressionObject)) {
            if (this.PM != null) {
                this.PM.move(this.oldx, this.oldy);
            } else if (this.O instanceof ExpressionObject) {
                ((ExpressionObject)this.O).setSliderPosition(this.oldx);
            }
            this.ZC.getConstruction().switchBack();
            this.ZC.dovalidate();
            this.ZC.repaint();
        }
        ObjectTracker objectTracker = this;
        synchronized (objectTracker) {
            this.notify();
        }
        this.Running = false;
        this.showStatus(this.ZC);
    }

    public void invalidate(ZirkelCanvas zirkelCanvas) {
        this.stop();
    }

    public void stop() {
        if (!this.Running) {
            return;
        }
        this.Stopped = true;
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ZC.repaint();
        this.showStatus(this.ZC);
    }

    public void save(XmlWriter xmlWriter) {
        if (this.P == null || this.O == null || this.PM == null && !(this.O instanceof ExpressionObject)) {
            return;
        }
        xmlWriter.startTagStart("Track");
        xmlWriter.printArg("track", this.P.getName());
        for (int i = 0; i < this.PN; ++i) {
            xmlWriter.printArg("track" + i, this.PO[i].getName());
        }
        xmlWriter.printArg("on", this.O.getName());
        if (this.PM != null) {
            xmlWriter.printArg("move", this.PM.getName());
        }
        if (this.Animate && this.Paint) {
            xmlWriter.printArg("animate", "true");
        } else if (this.Animate && !this.Paint) {
            xmlWriter.printArg("animate", "nopaint");
        }
        if (this.Omit > 1) {
            xmlWriter.printArg("omit", "" + (this.Omit - 1));
        }
        xmlWriter.finishTagNewLine();
    }

    public void pause(boolean bl) {
        if (bl && this.Running) {
            this.stop();
        }
    }

    public synchronized void compute(ZirkelCanvas zirkelCanvas) {
        if (!this.isComplete()) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.PM != null) {
            d2 = this.PM.getX();
            d3 = this.PM.getY();
        } else if (this.O instanceof ExpressionObject) {
            d2 = ((ExpressionObject)this.O).getSliderPosition();
        }
        zirkelCanvas.getConstruction().clearSwitches();
        zirkelCanvas.getConstruction().shouldSwitch(true);
        this.docompute(zirkelCanvas);
        zirkelCanvas.getConstruction().shouldSwitch(false);
        zirkelCanvas.getConstruction().clearSwitches();
        if (this.PM != null) {
            this.PM.move(d2, d3);
        } else if (this.O instanceof ExpressionObject) {
            ((ExpressionObject)this.O).setSliderPosition(d2);
        }
        zirkelCanvas.dovalidate();
    }

    public synchronized void docompute(ZirkelCanvas zirkelCanvas) {
        block80: {
            boolean bl;
            Object object;
            block81: {
                boolean bl2;
                Object object2;
                double d2;
                block79: {
                    boolean bl3;
                    Object object3;
                    double d3;
                    double d4;
                    double d5;
                    this.V = new Vector();
                    for (int i = 0; i < this.PN; ++i) {
                        this.VO[i] = new Vector();
                    }
                    this.VPM = new Vector();
                    if (!(this.O instanceof PrimitiveCircleObject)) break block79;
                    zirkelCanvas.getConstruction().shouldSwitch(false);
                    PrimitiveCircleObject primitiveCircleObject = (PrimitiveCircleObject)this.O;
                    double d6 = primitiveCircleObject.getX();
                    double d7 = primitiveCircleObject.getY();
                    double d8 = primitiveCircleObject.getR();
                    this.PM.project(primitiveCircleObject);
                    double d9 = 0.0;
                    double d10 = 0.0;
                    double d11 = 0.0;
                    double d12 = 0.0;
                    double d13 = 0.5;
                    boolean bl4 = false;
                    if (primitiveCircleObject.hasRange()) {
                        bl4 = true;
                        d5 = primitiveCircleObject.getA1();
                        d4 = primitiveCircleObject.getA2();
                        for (d3 = d4 - d5; d3 < 0.0; d3 += Math.PI * 2) {
                        }
                        while (d3 >= Math.PI * 2) {
                            d3 -= Math.PI * 2;
                        }
                        d9 = d11 = -d3 / 2.0;
                        d10 = d3 / 2.0;
                        d12 = (d5 + d4) / 2.0;
                    } else {
                        d11 = -3.141278494324434;
                        d9 = -3.141278494324434;
                        d10 = 3.141278494324434;
                    }
                    d5 = d11;
                    this.PM.move(d6 + d8 * Math.cos(d12 + d5), d7 + d8 * Math.sin(d12 + d5));
                    this.PM.project(primitiveCircleObject);
                    zirkelCanvas.getConstruction().validate(this.P, this.PM);
                    zirkelCanvas.resetSum();
                    d4 = 0.0;
                    d3 = 0.0;
                    boolean bl5 = false;
                    if (this.P.valid()) {
                        zirkelCanvas.getConstruction().shouldSwitch(true);
                        if (this.P instanceof PointObject) {
                            object3 = (PointObject)this.P;
                            d4 = ((PointObject)object3).getX();
                            d3 = ((PointObject)object3).getY();
                            this.V.addElement(new Coordinates(d4, d3));
                            this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                            bl5 = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            object3 = (PrimitiveLineObject)this.P;
                            this.X = ((PrimitiveLineObject)object3).getX();
                            this.Y = ((PrimitiveLineObject)object3).getY();
                            this.DX = ((PrimitiveLineObject)object3).getDX();
                            this.DY = ((PrimitiveLineObject)object3).getDY();
                            bl5 = true;
                        }
                    }
                    object3 = new boolean[this.PMax];
                    for (int i = 0; i < this.PN; ++i) {
                        object3[i] = false;
                    }
                    long l = System.currentTimeMillis();
                    this.addSecondary((boolean[])object3, zirkelCanvas);
                    double d14 = 0.001;
                    if (this.da < 1.0E-10 || this.da > zirkelCanvas.dx(1)) {
                        this.da = zirkelCanvas.dx(1) / 10.0;
                    }
                    double d15 = d5;
                    double d16 = 0.0;
                    double d17 = 0.0;
                    do {
                        d5 += this.da;
                        bl3 = false;
                        if ((!bl5 || bl4) && d5 >= d10) {
                            d5 = d10;
                            bl3 = true;
                        } else if ((!bl5 || bl4) && d5 <= d9) {
                            d5 = d9;
                            bl3 = true;
                        } else if (bl5 && this.da > 0.0 && this.mod(d15 - d11) < 0.0 && this.mod(d5 - d11) >= 0.0 && !zirkelCanvas.getConstruction().haveSwitched()) {
                            bl3 = true;
                            d5 = d11;
                        }
                        d15 = d5;
                        this.PM.move(d6 + d8 * Math.cos(d12 + d5), d7 + d8 * Math.sin(d12 + d5));
                        this.PM.project(primitiveCircleObject);
                        zirkelCanvas.getConstruction().validate(this.P, this.PM);
                        if (this.P.valid()) {
                            boolean bl6;
                            double d18;
                            if (!bl5) {
                                zirkelCanvas.getConstruction().shouldSwitch(true);
                                d11 = d5;
                            }
                            boolean bl7 = false;
                            if (this.P instanceof PointObject) {
                                PointObject pointObject = (PointObject)this.P;
                                d16 = pointObject.getX();
                                d17 = pointObject.getY();
                                bl7 = true;
                            } else if (this.P instanceof PrimitiveLineObject) {
                                PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.P;
                                if (!bl5) {
                                    this.X = primitiveLineObject.getX();
                                    this.Y = primitiveLineObject.getY();
                                    this.DX = primitiveLineObject.getDX();
                                    this.DY = primitiveLineObject.getDY();
                                } else {
                                    double d19;
                                    double d20 = primitiveLineObject.getX();
                                    d18 = primitiveLineObject.getY();
                                    double d21 = primitiveLineObject.getDX();
                                    double d22 = d21 * this.DY - (d19 = primitiveLineObject.getDY()) * this.DX;
                                    if (Math.sqrt(Math.abs(d22)) > 1.0E-9) {
                                        double d23 = (-(this.X - d20) * this.DY + this.DX * (this.Y - d18)) / -d22;
                                        d16 = d20 + d23 * d21;
                                        d17 = d18 + d23 * d19;
                                        bl7 = true;
                                    }
                                    this.X = d20;
                                    this.Y = d18;
                                    this.DX = d21;
                                    this.DY = d19;
                                }
                            }
                            double d24 = zirkelCanvas.dCenter(d16, d17);
                            boolean bl8 = bl6 = (int)zirkelCanvas.col(d4) != (int)zirkelCanvas.col(d16) || (int)zirkelCanvas.row(d3) != (int)zirkelCanvas.row(d17);
                            if (bl7 && bl6) {
                                this.V.addElement(new Coordinates(d16, d17));
                                this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                            }
                            d18 = Math.abs(d16 - d4) + Math.abs(d17 - d3);
                            this.da = this.updateDA(this.da, bl7, d24, d18, d14, d13, zirkelCanvas);
                            d4 = d16;
                            d3 = d17;
                            bl5 = true;
                        } else if (bl5) {
                            this.V.addElement(new Coordinates(d16, d17));
                            this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                            this.da = -this.da;
                        }
                        this.addSecondary((boolean[])object3, zirkelCanvas);
                    } while (!bl3 && System.currentTimeMillis() - l <= 5000L);
                    break block80;
                }
                if (!(this.O instanceof PrimitiveLineObject)) break block81;
                zirkelCanvas.getConstruction().shouldSwitch(false);
                PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.O;
                this.PM.project(primitiveLineObject);
                double d25 = primitiveLineObject.getX();
                double d26 = primitiveLineObject.getY();
                double d27 = primitiveLineObject.getDX();
                double d28 = primitiveLineObject.getDY();
                double d29 = 0.0;
                double d30 = 0.0;
                double d31 = 0.0;
                double d32 = 0.5;
                boolean bl9 = false;
                if (primitiveLineObject instanceof RayObject) {
                    d31 = 0.0;
                    d29 = 0.0;
                    d30 = 3.141278494324434;
                    bl9 = true;
                } else if (primitiveLineObject instanceof SegmentObject) {
                    d31 = 0.0;
                    d29 = 0.0;
                    d2 = ((SegmentObject)primitiveLineObject).getLength();
                    d32 = d2 / 20.0;
                    d30 = Math.atan(d2) * 2.0;
                    bl9 = true;
                } else {
                    d31 = -3.1415612376632573;
                    d29 = -3.1415612376632573;
                    d30 = 3.141278494324434;
                }
                d2 = d31;
                double d33 = Math.tan(this.mod(d2) / 2.0);
                this.PM.move(d25 + d33 * d27, d26 + d33 * d28);
                this.PM.project(primitiveLineObject);
                zirkelCanvas.getConstruction().validate(this.P, this.PM);
                zirkelCanvas.resetSum();
                double d34 = 0.0;
                double d35 = 0.0;
                boolean bl10 = false;
                if (this.P.valid()) {
                    zirkelCanvas.getConstruction().shouldSwitch(true);
                    if (this.P instanceof PointObject) {
                        object2 = (PointObject)this.P;
                        d34 = ((PointObject)object2).getX();
                        d35 = ((PointObject)object2).getY();
                        this.V.addElement(new Coordinates(d34, d35));
                        this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                        bl10 = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        object2 = (PrimitiveLineObject)this.P;
                        this.X = ((PrimitiveLineObject)object2).getX();
                        this.Y = ((PrimitiveLineObject)object2).getY();
                        this.DX = ((PrimitiveLineObject)object2).getDX();
                        this.DY = ((PrimitiveLineObject)object2).getDY();
                        bl10 = true;
                    }
                }
                object2 = new boolean[this.PMax];
                for (int i = 0; i < this.PN; ++i) {
                    object2[i] = false;
                }
                long l = System.currentTimeMillis();
                this.addSecondary((boolean[])object2, zirkelCanvas);
                double d36 = 0.001;
                if (this.da < 1.0E-10 || this.da > zirkelCanvas.dx(1)) {
                    this.da = zirkelCanvas.dx(1) / 10.0;
                }
                double d37 = d2;
                double d38 = 0.0;
                double d39 = 0.0;
                do {
                    d2 += this.da;
                    bl2 = false;
                    if ((!bl10 || bl9) && d2 >= d30) {
                        d2 = d30;
                        bl2 = true;
                    } else if ((!bl10 || bl9) && d2 <= d29) {
                        d2 = d29;
                        bl2 = true;
                    } else if (bl10 && this.da > 0.0 && this.mod(d37 - d31) < 0.0 && this.mod(d2 - d31) >= 0.0 && !zirkelCanvas.getConstruction().haveSwitched()) {
                        bl2 = true;
                        d2 = d31;
                    }
                    d37 = d2;
                    d33 = Math.tan(this.mod(d2) / 2.0);
                    this.PM.move(d25 + d33 * d27, d26 + d33 * d28);
                    this.PM.project(primitiveLineObject);
                    zirkelCanvas.getConstruction().validate(this.P, this.PM);
                    if (this.P.valid()) {
                        boolean bl11;
                        double d40;
                        if (!bl10) {
                            zirkelCanvas.getConstruction().shouldSwitch(true);
                            d31 = d2;
                        }
                        boolean bl12 = false;
                        if (this.P instanceof PointObject) {
                            PointObject pointObject = (PointObject)this.P;
                            d38 = pointObject.getX();
                            d39 = pointObject.getY();
                            bl12 = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            PrimitiveLineObject primitiveLineObject2 = (PrimitiveLineObject)this.P;
                            if (!bl10) {
                                this.X = primitiveLineObject2.getX();
                                this.Y = primitiveLineObject2.getY();
                                this.DX = primitiveLineObject2.getDX();
                                this.DY = primitiveLineObject2.getDY();
                            } else {
                                double d41;
                                double d42 = primitiveLineObject2.getX();
                                d40 = primitiveLineObject2.getY();
                                double d43 = primitiveLineObject2.getDX();
                                double d44 = d43 * this.DY - (d41 = primitiveLineObject2.getDY()) * this.DX;
                                if (Math.sqrt(Math.abs(d44)) > 1.0E-9) {
                                    double d45 = (-(this.X - d42) * this.DY + this.DX * (this.Y - d40)) / -d44;
                                    d38 = d42 + d45 * d43;
                                    d39 = d40 + d45 * d41;
                                    bl12 = true;
                                }
                                this.X = d42;
                                this.Y = d40;
                                this.DX = d43;
                                this.DY = d41;
                            }
                        }
                        double d46 = zirkelCanvas.dCenter(d38, d39);
                        boolean bl13 = bl11 = (int)zirkelCanvas.col(d34) != (int)zirkelCanvas.col(d38) || (int)zirkelCanvas.row(d35) != (int)zirkelCanvas.row(d39);
                        if (bl12 && bl11) {
                            this.V.addElement(new Coordinates(d38, d39));
                            this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                        }
                        d40 = Math.abs(d38 - d34) + Math.abs(d39 - d35);
                        this.da = this.updateDA(this.da, bl12, d46, d40, d36, d32, zirkelCanvas);
                        d34 = d38;
                        d35 = d39;
                        bl10 = true;
                    } else if (bl10) {
                        this.V.addElement(new Coordinates(d38, d39));
                        this.VPM.addElement(new Coordinates(this.PM.getX(), this.PM.getY()));
                        this.da = -this.da;
                    }
                    this.addSecondary((boolean[])object2, zirkelCanvas);
                } while (!bl2 && System.currentTimeMillis() - l <= 5000L);
                break block80;
            }
            if (!(this.O instanceof ExpressionObject)) break block80;
            zirkelCanvas.getConstruction().shouldSwitch(false);
            ExpressionObject expressionObject = (ExpressionObject)this.O;
            if (!expressionObject.isSlider()) {
                return;
            }
            double d47 = 0.0;
            double d48 = 0.0;
            double d49 = 0.0;
            double d50 = 0.5;
            boolean bl14 = false;
            d49 = 0.0;
            d47 = 0.0;
            double d51 = 1.0;
            d50 = d51 / 20.0;
            d48 = Math.atan(d51) * 2.0;
            bl14 = true;
            double d52 = d49;
            double d53 = Math.tan(this.mod(d52) / 2.0);
            expressionObject.setSliderPosition(0.0);
            zirkelCanvas.getConstruction().validate(this.P, null);
            zirkelCanvas.resetSum();
            double d54 = 0.0;
            double d55 = 0.0;
            boolean bl15 = false;
            if (this.P.valid()) {
                zirkelCanvas.getConstruction().shouldSwitch(true);
                if (this.P instanceof PointObject) {
                    object = (PointObject)this.P;
                    d54 = ((PointObject)object).getX();
                    d55 = ((PointObject)object).getY();
                    this.V.addElement(new Coordinates(d54, d55));
                    this.VPM.addElement(new Coordinates(expressionObject.getSliderPosition(), 0.0));
                    bl15 = true;
                } else if (this.P instanceof PrimitiveLineObject) {
                    object = (PrimitiveLineObject)this.P;
                    this.X = ((PrimitiveLineObject)object).getX();
                    this.Y = ((PrimitiveLineObject)object).getY();
                    this.DX = ((PrimitiveLineObject)object).getDX();
                    this.DY = ((PrimitiveLineObject)object).getDY();
                    bl15 = true;
                }
            }
            object = new boolean[this.PMax];
            for (int i = 0; i < this.PN; ++i) {
                object[i] = false;
            }
            long l = System.currentTimeMillis();
            this.addSecondary((boolean[])object, zirkelCanvas);
            double d56 = 0.001;
            if (this.da < 1.0E-10 || this.da > zirkelCanvas.dx(1)) {
                this.da = zirkelCanvas.dx(1) / 10.0;
            }
            double d57 = d52;
            double d58 = 0.0;
            double d59 = 0.0;
            do {
                d52 += this.da;
                bl = false;
                if ((!bl15 || bl14) && d52 >= d48) {
                    d52 = d48;
                    bl = true;
                } else if ((!bl15 || bl14) && d52 <= d47) {
                    d52 = d47;
                    bl = true;
                } else if (bl15 && this.da > 0.0 && this.mod(d57 - d49) < 0.0 && this.mod(d52 - d49) >= 0.0 && !zirkelCanvas.getConstruction().haveSwitched()) {
                    bl = true;
                    d52 = d49;
                }
                d57 = d52;
                d53 = Math.tan(this.mod(d52) / 2.0);
                expressionObject.setSliderPosition(d53);
                zirkelCanvas.getConstruction().validate(this.P, null);
                if (this.P.valid()) {
                    boolean bl16;
                    double d60;
                    if (!bl15) {
                        zirkelCanvas.getConstruction().shouldSwitch(true);
                        d49 = d52;
                    }
                    boolean bl17 = false;
                    if (this.P instanceof PointObject) {
                        PointObject pointObject = (PointObject)this.P;
                        d58 = pointObject.getX();
                        d59 = pointObject.getY();
                        bl17 = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.P;
                        if (!bl15) {
                            this.X = primitiveLineObject.getX();
                            this.Y = primitiveLineObject.getY();
                            this.DX = primitiveLineObject.getDX();
                            this.DY = primitiveLineObject.getDY();
                        } else {
                            double d61;
                            double d62 = primitiveLineObject.getX();
                            d60 = primitiveLineObject.getY();
                            double d63 = primitiveLineObject.getDX();
                            double d64 = d63 * this.DY - (d61 = primitiveLineObject.getDY()) * this.DX;
                            if (Math.sqrt(Math.abs(d64)) > 1.0E-9) {
                                double d65 = (-(this.X - d62) * this.DY + this.DX * (this.Y - d60)) / -d64;
                                d58 = d62 + d65 * d63;
                                d59 = d60 + d65 * d61;
                                bl17 = true;
                            }
                            this.X = d62;
                            this.Y = d60;
                            this.DX = d63;
                            this.DY = d61;
                        }
                    }
                    double d66 = zirkelCanvas.dCenter(d58, d59);
                    boolean bl18 = bl16 = (int)zirkelCanvas.col(d54) != (int)zirkelCanvas.col(d58) || (int)zirkelCanvas.row(d55) != (int)zirkelCanvas.row(d59);
                    if (bl17 && bl16) {
                        this.V.addElement(new Coordinates(d58, d59));
                        this.VPM.addElement(new Coordinates(expressionObject.getSliderPosition(), 0.0));
                    }
                    d60 = Math.abs(d58 - d54) + Math.abs(d59 - d55);
                    this.da = this.updateDA(this.da, bl17, d66, d60, d56, d50, zirkelCanvas);
                    d54 = d58;
                    d55 = d59;
                    bl15 = true;
                } else if (bl15) {
                    this.V.addElement(new Coordinates(d58, d59));
                    this.VPM.addElement(new Coordinates(expressionObject.getSliderPosition(), 0.0));
                    this.da = -this.da;
                }
                this.addSecondary((boolean[])object, zirkelCanvas);
            } while (!bl && System.currentTimeMillis() - l <= 5000L);
        }
    }

    public void addSecondary(boolean[] blArray, ZirkelCanvas zirkelCanvas) {
        for (int i = 0; i < this.PN; ++i) {
            double d2;
            ConstructionObject constructionObject;
            if (this.PM != null) {
                zirkelCanvas.getConstruction().validate(this.PO[i], this.PM);
            } else {
                zirkelCanvas.getConstruction().validate(this.PO[i], this.O);
            }
            if (!this.PO[i].valid()) continue;
            if (this.PO[i] instanceof PointObject) {
                constructionObject = (PointObject)this.PO[i];
                this.VO[i].addElement(new Coordinates(((PointObject)constructionObject).getX(), ((PointObject)constructionObject).getY()));
                continue;
            }
            if (!(this.PO[i] instanceof PrimitiveLineObject)) continue;
            constructionObject = (PrimitiveLineObject)this.PO[i];
            if (!blArray[i]) {
                this.XO[i] = ((PrimitiveLineObject)constructionObject).getX();
                this.YO[i] = ((PrimitiveLineObject)constructionObject).getY();
                this.DXO[i] = ((PrimitiveLineObject)constructionObject).getDX();
                this.DYO[i] = ((PrimitiveLineObject)constructionObject).getDY();
                blArray[i] = true;
                continue;
            }
            double d3 = ((PrimitiveLineObject)constructionObject).getX();
            double d4 = ((PrimitiveLineObject)constructionObject).getY();
            double d5 = ((PrimitiveLineObject)constructionObject).getDX();
            double d6 = d5 * this.DYO[i] - (d2 = ((PrimitiveLineObject)constructionObject).getDY()) * this.DXO[i];
            if (!(Math.sqrt(Math.abs(d6)) > 1.0E-9)) continue;
            double d7 = (-(this.XO[i] - d3) * this.DYO[i] + this.DXO[i] * (this.YO[i] - d4)) / -d6;
            this.XO[i] = d3;
            this.YO[i] = d4;
            this.DXO[i] = d5;
            this.DYO[i] = d2;
            this.VO[i].addElement(new Coordinates(d3 + d7 * d5, d4 + d7 * d2));
        }
    }

    public double updateDA(double d2, boolean bl, double d3, double d4, double d5, double d6, ZirkelCanvas zirkelCanvas) {
        if (this.V.size() > 0 && bl) {
            if (d3 < 1.2) {
                if (d4 > zirkelCanvas.dx(this.StepSize)) {
                    d2 /= 2.0;
                } else if (d4 < zirkelCanvas.dx(this.StepSize / 2.0)) {
                    d2 *= 2.0;
                }
                if (d2 > 0.0 && d2 < d5) {
                    d2 = d5;
                } else if (d2 < 0.0 && d2 > -d5) {
                    d2 = -d5;
                }
                if (d2 > d6) {
                    d2 = d6;
                } else if (d2 < -d6) {
                    d2 = -d6;
                }
            } else {
                if (d4 > zirkelCanvas.dx(this.StepSize * 10.0)) {
                    d2 /= 2.0;
                } else if (d4 < zirkelCanvas.dx(this.StepSize * 5.0)) {
                    d2 *= 2.0;
                }
                if (d2 > 0.0 && d2 < d5) {
                    d2 = d5;
                } else if (d2 < 0.0 && d2 > -d5) {
                    d2 = -d5;
                }
                if (d2 > d6) {
                    d2 = d6;
                } else if (d2 < -d6) {
                    d2 = -d6;
                }
            }
        }
        return d2;
    }

    public void increaseOmit() {
        ++this.Omit;
    }

    public void decreaseOmit() {
        if (this.Omit > 1) {
            --this.Omit;
        }
    }

    public void setOmit(int n) {
        this.Omit = n + 1;
    }

    public boolean isComplete() {
        return this.P != null && this.O != null && (this.PM != null || this.O instanceof ExpressionObject && ((ExpressionObject)this.O).isSlider());
    }

    public void keep(ZirkelCanvas zirkelCanvas) {
        if (!this.isComplete()) {
            return;
        }
        TrackObject trackObject = new TrackObject(zirkelCanvas.getConstruction(), this.P, this.PO, this.PN, this.O, this.PM);
        zirkelCanvas.addObject(trackObject);
        trackObject.setDefaults();
        this.reset(zirkelCanvas);
        trackObject.compute(zirkelCanvas);
        zirkelCanvas.validate();
    }

    public String getTag() {
        return "Track";
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Track")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("on") || !xmlTag.hasParam("track")) {
            throw new ConstructionException("Track parameters missing!");
        }
        try {
            PointObject pointObject = null;
            try {
                pointObject = (PointObject)construction.find(xmlTag.getValue("point"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConstructionObject constructionObject = construction.find(xmlTag.getValue("on"));
            if (pointObject == null && !(constructionObject instanceof ExpressionObject)) {
                throw new ConstructionException("");
            }
            ConstructionObject constructionObject2 = construction.find(xmlTag.getValue("track"));
            ConstructionObject[] constructionObjectArray = new ConstructionObject[this.PMax];
            int n = 0;
            for (n = 0; n < this.PMax && xmlTag.hasParam("track" + n); ++n) {
                constructionObjectArray[n] = construction.find(xmlTag.getValue("track" + n));
                if (constructionObjectArray[n] instanceof PointObject || constructionObjectArray[n] instanceof PrimitiveLineObject) continue;
                throw new ConstructionException("Track parameters wrong!");
            }
            if (constructionObject2 == null || constructionObject == null) {
                throw new ConstructionException("Track parameters wrong!");
            }
            if (!(constructionObject2 instanceof PointObject) && !(constructionObject2 instanceof PrimitiveLineObject)) {
                throw new ConstructionException("Track parameters wrong!");
            }
            if (!(constructionObject instanceof PrimitiveCircleObject || constructionObject instanceof PrimitiveLineObject || constructionObject instanceof ExpressionObject)) {
                throw new ConstructionException("Track parameters wrong!");
            }
            TrackObject trackObject = new TrackObject(construction, constructionObject2, constructionObjectArray, n, constructionObject, pointObject);
            if (xmlTag.hasParam("filled")) {
                trackObject.setFilled(true);
            }
            if (xmlTag.hasParam("fixed")) {
                trackObject.setFixed(true);
            }
            if (xmlTag.hasParam("dmin")) {
                try {
                    trackObject.setDMin(new Double(xmlTag.getValue("dmin")));
                }
                catch (Exception exception) {
                    throw new ConstructionException("Track parameters wrong!");
                }
            }
            if (xmlTag.hasTrueParam("discrete")) {
                trackObject.setDiscrete(true);
            }
            this.setType(xmlTag, trackObject);
            this.setName(xmlTag, trackObject);
            this.set(xmlTree, trackObject);
            construction.add(trackObject);
            this.setConditionals(xmlTree, construction, trackObject);
            return true;
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Track Parameters wrong!");
        }
    }

    public void setType(XmlTag xmlTag, TrackObject trackObject) {
        if (xmlTag.hasParam("shape")) {
            String string = xmlTag.getValue("shape");
            if (string.equals("square")) {
                trackObject.setType(0);
            }
            if (string.equals("diamond")) {
                trackObject.setType(1);
            }
            if (string.equals("circle")) {
                trackObject.setType(2);
            }
            if (string.equals("dot")) {
                trackObject.setType(3);
            }
            if (string.equals("cross")) {
                trackObject.setType(4);
            }
            if (string.equals("dcross")) {
                trackObject.setType(5);
            }
        }
    }
}

