
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was libfyaml-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# libfyaml CMake package configuration file
# This file provides libfyaml imported targets and dependencies

include(CMakeFindDependencyMacro)

# Provide version information
set(libfyaml_VERSION "0.9.5")
set(libfyaml_VERSION_MAJOR "0")
set(libfyaml_VERSION_MINOR "9")
set(libfyaml_VERSION_PATCH "5")

# Provide feature flags (what was enabled when libfyaml was built)
set(libfyaml_HAS_LIBCLANG "0")
set(libfyaml_HAS_LIBYAML "0")

# Required dependency: Threads
set(CMAKE_THREAD_PREFER_PTHREAD TRUE)
set(THREADS_PREFER_PTHREAD_FLAG TRUE)
find_dependency(Threads REQUIRED)

# Optional dependency: libclang (only if libfyaml was built with reflection support)
if(libfyaml_HAS_LIBCLANG)
    # Try CMake config first
    find_dependency(LLVM QUIET CONFIG)
    if(LLVM_FOUND)
        # Help find Clang in the same LLVM installation
        set(Clang_DIR "${LLVM_INSTALL_PREFIX}/lib/cmake/clang")
    endif()
    find_dependency(Clang QUIET CONFIG)

    # If CMake config not found, try pkg-config as fallback
    if(NOT LLVM_FOUND OR NOT Clang_FOUND)
        # User must provide libclang manually if needed
        message(STATUS "libfyaml was built with libclang support, but libclang not found via CMake config")
        message(STATUS "  Set CMAKE_PREFIX_PATH or LLVM_DIR to locate LLVM/Clang")
    endif()
endif()

# Import libfyaml targets (defines libfyaml::fyaml)
include(${CMAKE_CURRENT_LIST_DIR}/libfyaml-targets.cmake)

# Provide consistent naming: libfyaml::libfyaml as main target
if(NOT TARGET libfyaml::libfyaml AND TARGET libfyaml::fyaml)
    add_library(libfyaml::libfyaml ALIAS libfyaml::fyaml)
endif()

# Backward compatibility: provide non-namespaced target
if(NOT TARGET fyaml AND TARGET libfyaml::fyaml)
    add_library(fyaml ALIAS libfyaml::fyaml)
endif()

check_required_components(libfyaml)
