/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslInputStream
extends InputStream {
    private static final boolean debug = false;
    private byte[] saslBuffer;
    private byte[] lenBuf = new byte[4];
    private byte[] buf = new byte[0];
    private int bufPos = 0;
    private InputStream in;
    private SaslClient sc;
    private int recvMaxBufSize = 65536;

    SaslInputStream(SaslClient saslClient, InputStream inputStream) throws SaslException {
        this.in = inputStream;
        this.sc = saslClient;
        String string = (String)saslClient.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        if (string != null) {
            try {
                this.recvMaxBufSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SaslException("javax.security.sasl.maxbuffer property must be numeric string: " + string);
            }
        }
        this.saslBuffer = new byte[this.recvMaxBufSize];
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n > 0) {
            return byArray[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.bufPos >= this.buf.length) {
            n3 = this.fill();
            while (n3 == 0) {
                n3 = this.fill();
            }
            if (n3 == -1) {
                return -1;
            }
        }
        if (n2 > (n3 = this.buf.length - this.bufPos)) {
            System.arraycopy(this.buf, this.bufPos, byArray, n, n3);
            this.bufPos = this.buf.length;
            return n3;
        }
        System.arraycopy(this.buf, this.bufPos, byArray, n, n2);
        this.bufPos += n2;
        return n2;
    }

    private int fill() throws IOException {
        int n = this.readFully(this.lenBuf, 4);
        if (n != 4) {
            return -1;
        }
        int n2 = SaslInputStream.networkByteOrderToInt(this.lenBuf, 0, 4);
        if (n2 > this.recvMaxBufSize) {
            throw new IOException(n2 + "exceeds the negotiated receive buffer size limit:" + this.recvMaxBufSize);
        }
        n = this.readFully(this.saslBuffer, n2);
        if (n != n2) {
            throw new EOFException("Expecting to read " + n2 + " bytes but got " + n + " bytes before EOF");
        }
        this.buf = this.sc.unwrap(this.saslBuffer, 0, n2);
        this.bufPos = 0;
        return this.buf.length;
    }

    private int readFully(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            int n3 = this.in.read(byArray, n2, n);
            if (n3 == -1) {
                return n2 == 0 ? -1 : n2;
            }
            n2 += n3;
            n -= n3;
        }
        return n2;
    }

    @Override
    public int available() throws IOException {
        return this.buf.length - this.bufPos;
    }

    @Override
    public void close() throws IOException {
        SaslException saslException = null;
        try {
            this.sc.dispose();
        }
        catch (SaslException saslException2) {
            saslException = saslException2;
        }
        this.in.close();
        if (saslException != null) {
            throw saslException;
        }
    }

    private static int networkByteOrderToInt(byte[] byArray, int n, int n2) {
        if (n2 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 8;
            n3 |= byArray[n + i] & 0xFF;
        }
        return n3;
    }
}

