# $NetBSD: web.prefs.mk,v 1.9 2007/06/09 22:52:16 rillig Exp $
#

# This file contains the default values (``preferences'') for commonly
# used variables that can be overridden in /etc/mk.conf. Before using
# such variables in Makefiles, this file must be included.

.if !defined(_WEB_PREFS_MK)
_WEB_PREFS_MK=		# defined

#
# Look for the root directory of htdocs. Currently five subdirectory
# levels are enough to handle all web pages.
#
_HTDOCS_SUBDIRS=	# none
.for d in . .. ../.. ../../.. ../../../.. ../../../../..
.  if !defined(_HTDOCS_TOPDIR)
_HTDOCS_SUBDIRS+=	${d}
.    if exists(${.CURDIR}/${d}/share/mk/web.site.mk)
_HTDOCS_RELTOPDIR=	${d}
_HTDOCS_TOPDIR!=	cd ${.CURDIR}/${d} && exec pwd
.      if "${d}" == "."
_HTDOCS_SUBDIR?=	.
.      else
_HTDOCS_SUBDIR?=	${.CURDIR:S,^${_HTDOCS_TOPDIR}/,,}
.      endif
.    endif
.  endif
.endfor

.if !defined(_HTDOCS_SUBDIR) && defined(WEB_PREFIX)
_HTDOCS_TOPDIR!=	cd ${WEB_PREFIX} && exec pwd
_HTDOCS_SUBDIRS=	# none
_HTDOCS_RELTOPDIR=	${HTDOCS_TOPDIR}
_HTDOCS_SUBDIR=		${.CURDIR:S,^${_HTDOCS_TOPDIR}/,,}
.endif

#
# The following variables may be inspected in mk.conf.
# They must not be modified.
#

# All definitions in mk.conf that are related to htdocs should be put
# between .if defined(BUILDING_HTDOCS) ... .endif to not interfere with
# other settings.
#
BUILDING_HTDOCS=	yes

# An absolute pathname to the htdocs top-level directory.
#
WEB_PREFIX?=		${.CURDIR}/${_HTDOCS_RELTOPDIR}

# The absolute, canonical pathname of the htdocs top-level directory.
#
HTDOCS_TOPDIR=		${_HTDOCS_TOPDIR}

# The relative pathname to the htdocs top-level directory, being either
# "." or a sequence of "..".
#
HTDOCS_RELTOPDIR=	${_HTDOCS_RELTOPDIR}

# The current subdirectory in htdocs.
#
HTDOCS_SUBDIR=		${_HTDOCS_SUBDIR}

#
# The following variables are default settings that may be overridden in
# mk.conf.
#

# Are we on the host www.NetBSD.org?
# Possible values: YES, yes, NO, no.
#
NBWWW?=			no

# To show the output of the shell commands that are passed to the shell,
# set DEBUG_LEVEL to 1. To additionally see the commands that are
# actually executed by the shell, set DEBUG_LEVEL to 2.
#
DEBUG_LEVEL?=		0

#
# Include /etc/mk.conf indirectly. 
#
NEED_OWN_INSTALL_TARGET=	no	# Disable some dependency magic
BSD_PKG_MK=				# defined
.include <bsd.own.mk>

#
# Process the user settings.
#

.if ${DEBUG_LEVEL} == "0"
RUN?=			@set -e;
.elif ${DEBUG_LEVEL} == "1"
RUN?=			set -e;
.elif ${DEBUG_LEVEL} == "2"
RUN?=			set -e; set -x;
.else
RUN?=			# nothing
ERRORS+=		"DEBUG_LEVEL is \""${DEBUG_LEVEL:Q}"\", but must be either 0, 1 or 2."
.endif

#
# Include all Makefile.inc files on the way from ${.CURDIR} to
# ${WEB_PREFIX}. This is done here so that after including this file,
# the Makefiles can use the variables defined in the Makefile.inc files
# in dependency lines and other contexts that are evaluated at load
# time.
#
.for d in ${_HTDOCS_SUBDIRS}
.  if exists(${.CURDIR}/${d}/Makefile.inc)
.    include "${.CURDIR}/${d}/Makefile.inc"
.  endif
.endfor

.endif # _WEB_PREFS_MK
