<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">
                          <!ENTITY reg "&#174;">
                          <!ENTITY ldquo "&#8220;">
                          <!ENTITY rdquo "&#8221;">
                          <!ENTITY % misc SYSTEM "../xml/misc.ent"> %misc;]>



<!-- $NetBSD: errorpage.xsl,v 1.41 2025/07/31 07:40:21 andvar Exp $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:html="http://www.w3.org/1999/xhtml"
		exclude-result-prefixes="html"
		version="1.0">

<!-- enforce utf-8 output -->
<xsl:output method="html" encoding="utf-8"/>

<xsl:include href="portpage.xsl"/>
<xsl:include href="citerefentry.xsl"/>

<xsl:param name="toc.section.depth" select="3" />

<xsl:template match="processing-instruction('sdataEntity')">
  <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
  <xsl:value-of select="substring-before(.,' [')" />
  <xsl:text>;</xsl:text>
</xsl:template>

<!-- local overrides, from website-common.xsl -->
<!-- ==================================================================== -->

<xsl:template name="allpages.banner">
  <div id="top">
    <a href="#mainContent" id="skiplink" tabindex="1">Skip to main content.</a>
  </div>



      <!-- mobile menu icon -->
      <input id="hamburger" type="checkbox"/>
      <label class="menuicon" for="hamburger"><span></span><span></span><span></span></label>

      <div id="navBar" role="navigation">
	<div id="centralHeader">
	  <div id="logo">  
	  <a>
	    <xsl:attribute name="href">
	      <xsl:text>/</xsl:text>
	    </xsl:attribute>
	    <img id="projectLogo" alt="" height="120">
	      <xsl:attribute name="src">
		<xsl:text>/images/NetBSD-smaller-tb.png</xsl:text>
	      </xsl:attribute>
	    </img>
	  </a>
	  <a>
	    <xsl:attribute name="href">
	      <xsl:text>/</xsl:text>
	    </xsl:attribute>
	    <div id="fundraiser">
	      <br />
	      <div id="fundraiser-amount">
		<div id="fundraiser-raised"></div>
	      </div>
	    </div>
	  </a>
	  </div>
	</div>
	<span class="doNotDisplay">
	  Navigation:
	</span>
      <ul>

	<li><a>
	  <xsl:attribute name="href">
	    <xsl:text>/</xsl:text>
	  </xsl:attribute>
	  Home</a>
	  <ul>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/changes/</xsl:text>
	    </xsl:attribute>
	    Recent changes</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//blog.NetBSD.org/</xsl:text>
	    </xsl:attribute>
	    NetBSD blog</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/gallery/presentations/</xsl:text>
	    </xsl:attribute>
	    Presentations</a>
	    </li>
	  </ul>
	</li>

	<li><a>
	  <xsl:attribute name="href">
	    <xsl:text>/about/</xsl:text>
	  </xsl:attribute>
	  About</a>
	  <ul>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/people/developers.html</xsl:text>
	    </xsl:attribute>
	    Developers</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/gallery/</xsl:text>
	    </xsl:attribute>
	    Gallery</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//wiki.NetBSD.org/ports/</xsl:text>
	    </xsl:attribute>
	    Ports</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//www.pkgsrc.org/</xsl:text>
	    </xsl:attribute>
	    Packages</a>
	    </li>
	  </ul>
	</li>

	<li><a>
	  <xsl:attribute name="href">
	    <xsl:text>/docs/</xsl:text>
	  </xsl:attribute>
	  Documentation</a>
	  <ul>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/docs/misc/index.html</xsl:text>
	    </xsl:attribute>
	    FAQ &amp; HOWTOs</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/docs/guide/en/</xsl:text>
	    </xsl:attribute>
	    The Guide</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//man.NetBSD.org/</xsl:text>
	    </xsl:attribute>
	    Manual pages</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//wiki.NetBSD.org/</xsl:text>
	    </xsl:attribute>
	    Wiki</a>
	    </li>
	  </ul>
	</li>

	<li><a>
	  <xsl:attribute name="href">
	    <xsl:text>/support/</xsl:text>
	  </xsl:attribute>
	  Support</a>
	  <ul>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/community/</xsl:text>
	    </xsl:attribute>
	    Community</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/mailinglists/</xsl:text>
	    </xsl:attribute>
	    Mailing lists</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
		    <xsl:text>/support/send-pr.html</xsl:text>
	    </xsl:attribute>
	    Bug reports</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>/support/security/</xsl:text>
	    </xsl:attribute>
	    Security</a>
	    </li>
	  </ul>
	</li>

	<li><a>
	  <xsl:attribute name="href">
	    <xsl:text>/developers/</xsl:text>
	  </xsl:attribute>
	  Developers</a>
	  <ul>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>http://cvsweb.NetBSD.org/</xsl:text>
	    </xsl:attribute>
	    CVSWeb</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//anonhg.NetBSD.org/</xsl:text>
	    </xsl:attribute>
	    Mercurial</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//nxr.NetBSD.org/</xsl:text>
	    </xsl:attribute>
	    Cross-reference</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//releng.NetBSD.org/</xsl:text>
	    </xsl:attribute>
	    Release engineering</a>
	    </li>
	    <li><a>
	    <xsl:attribute name="href">
	      <xsl:text>//wiki.NetBSD.org/projects/</xsl:text>
	    </xsl:attribute>
	    Projects list</a>
	    </li>
	  </ul>
	</li>
      </ul>
      </div>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template name="webpage.table.footer"/>

<xsl:template name="webpage.footer">
   <xsl:variable name="page" select="."/>
  <xsl:variable name="cvstag" select="$page/config[@param='cvstag']/@value"/>
  <xsl:variable name="footers" select="$page/config[@param='footer']
                                       |$page/config[@param='footlink']
                                       |$autolayout/autolayout/config[@param='footer']
                                       |$autolayout/autolayout/config[@param='footlink']"/>

  <xsl:variable name="tocentry" select="$autolayout//*[@id=$page/@id]"/>
  <xsl:variable name="toc" select="($tocentry/ancestor-or-self::toc[1]
                                   | $autolayout//toc[1])[last()]"/>

  <xsl:variable name="feedback">
    <xsl:choose>
      <xsl:when test="$page/config[@param='feedback.href']">
        <xsl:value-of select="($page/config[@param='feedback.href'])[1]/@value"/>
      </xsl:when>
      <xsl:when test="$autolayout/autolayout/config[@param='feedback.href']">
        <xsl:value-of select="($autolayout/autolayout/config[@param='feedback.href'])[1]/@value"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$feedback.href"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="not($toc)">
      <xsl:message>
        <xsl:text>Cannot determine TOC for </xsl:text>
        <xsl:value-of select="$page/@id"/>
      </xsl:message>
    </xsl:when>
    <xsl:when test="$toc/@id = $page/@id">
      <!-- nop; this is the home page -->
    </xsl:when>
    <xsl:otherwise>
      <div class="navfoot">
<!-- 	<div class="foothome"> -->
<!-- 	  <a> -->
<!-- 	    <xsl:attribute name="href"> -->
<!-- 	      <xsl:call-template name="homeuri"/> -->
<!-- 	    </xsl:attribute> -->
<!-- 	    <xsl:value-of select="$foothome.text"/> -->
<!-- 	  </a> -->
<!-- 	</div> -->
<!--         <table border="0" summary="Footer navigation"> -->
<!--           <tr> -->
<!--             <td class="foothome"> -->
<!--               <span class="foothome"> -->
<!--                 <a> -->
<!--                   <xsl:attribute name="href"> -->
<!--                     <xsl:call-template name="homeuri"/> -->
<!--                   </xsl:attribute> -->
<!--                   <img src="/images/NetBSD-flag.png" -->
<!--                     alt="[NetBSD flag]" border="0" width="90" height="90"/> -->
<!--                 </a> -->
<!--               </span> -->
<!--             </td> -->
<!--             <td class="foothome"> -->
<!--               <span class="foothome"> -->
<!--                 <a> -->
<!--                   <xsl:attribute name="href"> -->
<!--                     <xsl:call-template name="homeuri"/> -->
<!--                   </xsl:attribute> -->
<!--                   <xsl:value-of select="$foothome.text"/> -->
<!--                 </a> -->
<!--               </span> -->
<!--               <br/> -->
<!--             </td> -->
<!--           </tr> -->
<!--         </table> -->

      </div>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:apply-templates select="$footers" mode="footer.link.mode"/>
  <div id="footer">
  <div id="footerContent">
  <p style="text-align:center;">
  <xsl:choose>
    <xsl:when test="$feedback != ''">
      <span class="footfeed">
        <a>
          <xsl:choose>
            <xsl:when test="$feedback.with.ids != 0">
              <xsl:attribute name="href">
                <xsl:value-of select="$feedback"/>
                <xsl:value-of select="$page/@id"/>
              </xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="href">
                <xsl:value-of select="$feedback"/>
              </xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
	  Contact</a> |
      </span>
    </xsl:when>
  </xsl:choose>

  <span class="footcopy">
    <a>
      <xsl:attribute name="href">
	<xsl:text>/about/disclaimer.html</xsl:text>
      </xsl:attribute>
      Disclaimer</a> |

      <xsl:choose>
        <xsl:when test="head/copyright">
          <xsl:apply-templates select="head/copyright" mode="footer.mode"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates mode="footer.mode"
                             select="$autolayout/autolayout/copyright"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text>ALL RIGHTS RESERVED.</xsl:text>
      <br />
      <xsl:text>NetBSD</xsl:text>
	<sup><xsl:text>&reg;</xsl:text></sup>
	<xsl:text> is a registered trademark of The NetBSD
	Foundation, Inc.</xsl:text>
  </span>
  </p>

  <xsl:if test="$sequential.links != 0">
    <xsl:variable name="prev">
      <xsl:call-template name="prev.page"/>
    </xsl:variable>
    <xsl:variable name="next">
      <xsl:call-template name="next.page"/>
    </xsl:variable>
    <xsl:variable name="ptoc"
                  select="$autolayout/autolayout//*[$prev=@id]"/>
    <xsl:variable name="ntoc"
                  select="$autolayout/autolayout//*[$next=@id]"/>

    <xsl:choose>
      <xsl:when test="$prev != ''">
        <xsl:call-template name="link.to.page">
          <xsl:with-param name="frompage" select="$tocentry"/>
          <xsl:with-param name="page" select="$ptoc"/>
          <xsl:with-param name="linktext" select="'Prev'"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>&#160;</xsl:otherwise>
    </xsl:choose>
    &#160;
    <xsl:choose>
      <xsl:when test="$next != ''">
        <xsl:call-template name="link.to.page">
          <xsl:with-param name="frompage" select="$tocentry"/>
          <xsl:with-param name="page" select="$ntoc"/>
          <xsl:with-param name="linktext" select="'Next'"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>&#160;</xsl:otherwise>
    </xsl:choose>
  </xsl:if>
  </div>
  </div>
</xsl:template>

<!--
  Use the `user.head.content` template to insert a custom meta element inside
  the head element. For reference, see Bob Stayton,
  DocBook XSL: The Complete Guide, Fourth Edition:
  https://sagehill.net/docbookxsl/InsertExtHtml.html#CodeInHead
  Refer to PR misc/59525 for additional context.
-->
<xsl:template name="user.head.content" mode="head.mode">
  <xsl:element name="meta">
    <xsl:attribute name="name">
      <xsl:text>viewport</xsl:text>
    </xsl:attribute>
    <xsl:attribute name="content">
      <xsl:text>width=device-width, initial-scale=1.0, minimum-scale=1.0</xsl:text>
    </xsl:attribute>
  </xsl:element>
</xsl:template>

<xsl:template match="sect1[@role = 'NotInToc']"  mode="toc" />
<xsl:template match="sect2[@role = 'NotInToc']"  mode="toc" />
<xsl:template match="sect3[@role = 'NotInToc']"  mode="toc" />
<xsl:template match="sect4[@role = 'NotInToc']"  mode="toc" />

<xsl:template match="webpage">
  <xsl:variable name="page" select="."/>
  <xsl:variable name="port" select="$page/@portpage"/>
  <xsl:variable name="id">
    <xsl:call-template name="object.id"/>
  </xsl:variable>

  <xsl:variable name="filename">
    <xsl:apply-templates select="." mode="filename"/>
  </xsl:variable>

  <xsl:variable name="tocentry" select="$autolayout/autolayout//*[$id=@id]"/>
  <xsl:variable name="toc" select="$tocentry/ancestor-or-self::toc"/>

  <html lang="en">
    <xsl:apply-templates select="head" mode="head.mode"/>
    <xsl:apply-templates select="config" mode="head.mode"/>
    <body class="website">
      <xsl:call-template name="body.attributes"/>

      <div class="{name(.)}" id="{$id}">

        <xsl:if test="$banner.before.navigation != 0">
          <xsl:call-template name="allpages.banner"/>
        </xsl:if>

<!-- we don't want the default toc at the top -->
<!--
        <xsl:if test="$toc">
          <div class="navhead">
            <xsl:apply-templates select="$toc">
              <xsl:with-param name="pageid" select="@id"/>
            </xsl:apply-templates>
            <xsl:if test="$header.hr != 0"><hr/></xsl:if>
          </div>
        </xsl:if>
-->
        <xsl:if test="$banner.before.navigation = 0">
          <xsl:call-template name="allpages.banner"/>
        </xsl:if>

	<xsl:choose>
	  <xsl:when test="not($port)">
	    <div id="content">
	      <div id="mainContent" class="fullWidth">
		<div class="rowOfBoxes">
            <xsl:apply-templates select="head/title" mode="title.mode"/>
	    <xsl:apply-templates select="child::*[name(.)!='webpage']"/>
		</div>
	      </div>
	    </div>
	    <xsl:call-template name="process.footnotes"/>
	    <xsl:call-template name="webpage.footer"/>
	  </xsl:when>
	  <xsl:when test="$port">
	    <div id="content">
	      <div id="mainContent" class="fullWidth">
		<div class="rowOfBoxes">
	    <xsl:apply-templates select="child::*[name(.)!='webpage']"/>
		</div>
	        <xsl:call-template name="process.footnotes"/>
	      </div>
	    </div>
	    <xsl:call-template name="webpage.footer"/>
	  </xsl:when>
	</xsl:choose>
      </div>
    </body>
  </html>
</xsl:template>

<xsl:template match="parentsec">
  <xsl:variable name="parentsec" select="."/>
  <hr/>
  <xsl:value-of select="$locale.backto" />
  <xsl:text>&nbsp;</xsl:text>
  <em><a href="{$parentsec/@url}"><xsl:value-of select="$parentsec/@text"/></a></em>
</xsl:template>

<xsl:template match="small">
  <font size="-1">
  <xsl:apply-templates />
  </font>
</xsl:template>

<xsl:template match="currentsrc">
   <xsl:variable name="currentsrc" select="."/>
   <a>
     <xsl:attribute name="href">
       <xsl:text>http://cvsweb.NetBSD.org/bsdweb.cgi/</xsl:text>
       <xsl:value-of select="$currentsrc"/> 
       <xsl:text>?rev=HEAD&amp;content-type=text/x-cvsweb-markup</xsl:text>
     </xsl:attribute>
     <xsl:value-of select="$currentsrc"/>
   </a>
</xsl:template>


<!-- Generate a change list -->
<xsl:template match="sect1[@role='toc']">
  <xsl:variable name="title" select="title"/>
  <xsl:if test="$title != ''">
    <h2 class="title"><xsl:apply-templates select="title" mode="plaintext"/>
    </h2>
  </xsl:if>
  <xsl:for-each select="sect2">
    <h3 class="title">
      <xsl:apply-templates select="title" mode="plaintext"/>
    </h3>
    <ul>
      <xsl:for-each select="sect3">
        <li><a href="#{@id}"><xsl:apply-templates select="title" mode="plaintext"/>
	</a></li>
      </xsl:for-each>
    </ul>
  </xsl:for-each>
  <xsl:for-each select="sect2">
    <hr/>
    <h3 class="title"><xsl:apply-templates select="title" mode="plaintext"/>
    </h3>
    <xsl:apply-templates select="para"/>
    <xsl:for-each select="sect3">
      <xsl:apply-templates/>
    </xsl:for-each>
  </xsl:for-each>
</xsl:template>

<xsl:template match="sect1[@role='toc']/sect2/sect3/title">
  <h4 class="title" id="{ancestor::sect3/@id}">
    <xsl:apply-templates/>
  </h4>
</xsl:template>

<!--
  With mode="plaintext" the template produces plain text without any markup.
  This can be used to get nicer output than the simple text concatenation of
  "xsl:value-of".
-->
<xsl:template match="sect1[@role='toc']/sect2/sect3/title" mode="plaintext">
    <xsl:apply-templates mode="plaintext" /> 
</xsl:template>

<!--
  XXX: this change possible should go into DocBook/Website repository,
  or it might be xsltproc "bug".

  Do not provide expicit namespace for html:* nodes. Otherwise it would
  result in stray 'xmlns=""' attributes with <html:form> and friends, which
  is also affects on descendant nodes, like XMLized <input>, etc.
-->
<xsl:template match="html:*">
  <xsl:element name="{local-name(.)}">
    <xsl:apply-templates select="@*" mode="copy"/>
    <xsl:apply-templates/>
  </xsl:element>
</xsl:template>

<xsl:template match="count-children">
  <xsl:param name="parent" select="@parent" />
  <xsl:param name="element" select="@element" />
  <xsl:value-of select="count(id($parent)//*[local-name() = $element])" />
</xsl:template>

</xsl:stylesheet>
