/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;

public class FtpConnexion {
    private final String user;
    private final Map<String, String> incoming = new HashMap<String, String>();
    private final Map<String, byte[]> outgoing = new HashMap<String, byte[]>();
    private final Set<String> futureOutgoing = new HashSet<String>();
    private FileFormat fileFormat;

    public FtpConnexion(String user, FileFormat defaultfileFormat) {
        this.user = user;
        this.fileFormat = defaultfileFormat;
    }

    public synchronized void addIncoming(String fileName, String data) {
        if (fileName.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        this.incoming.put(fileName, data);
    }

    public synchronized void futureOutgoing(String fileName) {
        this.outgoing.remove(fileName);
        this.futureOutgoing.add(fileName);
    }

    public synchronized Collection<String> getFiles() {
        ArrayList<String> result = new ArrayList<String>(this.incoming.keySet());
        result.addAll(this.outgoing.keySet());
        return Collections.unmodifiableCollection(result);
    }

    public synchronized boolean willExist(String fileName) {
        if (this.incoming.containsKey(fileName)) {
            return true;
        }
        if (this.outgoing.containsKey(fileName)) {
            return true;
        }
        return this.futureOutgoing.contains(fileName);
    }

    public synchronized byte[] getData(String fileName) throws InterruptedException {
        if (fileName.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String data = this.incoming.get(fileName);
        if (data != null) {
            return data.getBytes();
        }
        while (this.willExist(fileName)) {
            byte[] data2 = this.outgoing.get(fileName);
            if (data2 != null) {
                return data2;
            }
            Thread.sleep(200L);
        }
        return null;
    }

    public synchronized int getSize(String fileName) {
        if (fileName.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String data = this.incoming.get(fileName);
        if (data != null) {
            return data.length();
        }
        byte[] data2 = this.outgoing.get(fileName);
        if (data2 != null) {
            return data2.length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImage(String fileName) throws IOException {
        if (fileName.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String pngFileName = this.getFutureFileName(fileName);
        boolean done = false;
        try {
            SourceStringReader sourceStringReader = new SourceStringReader(this.incoming.get(fileName));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileFormat format = this.getFileFormat();
            DiagramDescription desc = sourceStringReader.generateDiagramDescription((OutputStream)baos, new FileFormatOption(format));
            String errorFileName = pngFileName.substring(0, pngFileName.length() - 4) + ".err";
            FtpConnexion ftpConnexion = this;
            synchronized (ftpConnexion) {
                this.outgoing.remove(pngFileName);
                this.futureOutgoing.remove(pngFileName);
                this.outgoing.remove(errorFileName);
                if (desc != null && desc.getDescription() != null) {
                    this.outgoing.put(pngFileName, baos.toByteArray());
                    done = true;
                    if (desc.getDescription().startsWith("(Error)")) {
                        ByteArrayOutputStream errBaos = new ByteArrayOutputStream();
                        sourceStringReader.generateImage((OutputStream)errBaos, new FileFormatOption(FileFormat.ATXT));
                        errBaos.close();
                        this.outgoing.put(errorFileName, errBaos.toByteArray());
                    }
                }
            }
        }
        finally {
            if (!done) {
                this.outgoing.put(pngFileName, new byte[0]);
            }
        }
    }

    public String getFutureFileName(String fileName) {
        return this.getFileFormat().changeName(fileName, 0);
    }

    private FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public synchronized void delete(String fileName) {
        this.incoming.remove(fileName);
        this.outgoing.remove(fileName);
        this.futureOutgoing.add(fileName);
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }
}

