/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TileImage;
import net.sourceforge.plantuml.graphic.TileImageSvg;

public class Img
implements HtmlCommand {
    private static final Pattern srcPattern = MyPattern.cmpile("(?i)src[%s]*=[%s]*[\"%q]?([^%s\">]+)[\"%q]?");
    private static final Pattern vspacePattern = MyPattern.cmpile("(?i)vspace[%s]*=[%s]*[\"%q]?(\\d+)[\"%q]?");
    private static final Pattern valignPattern = MyPattern.cmpile("(?i)valign[%s]*=[%s]*[\"%q]?(top|bottom|middle)[\"%q]?");
    private static final Pattern noSrcColonPattern = MyPattern.cmpile("(?i)\\<img[\\s:]+([^>]+)/?\\>");
    private final TextBlock tileImage;

    private Img(TextBlock image) {
        this.tileImage = image;
    }

    static int getVspace(String html) {
        Matcher m = vspacePattern.matcher(html);
        if (!m.find()) {
            return 0;
        }
        return Integer.parseInt(m.group(1));
    }

    static ImgValign getValign(String html) {
        Matcher m = valignPattern.matcher(html);
        if (!m.find()) {
            return ImgValign.TOP;
        }
        return ImgValign.valueOf(StringUtils.goUpperCase(m.group(1)));
    }

    static HtmlCommand getInstance(String html, boolean withSrc) {
        if (withSrc) {
            Matcher m = srcPattern.matcher(html);
            int vspace = Img.getVspace(html);
            ImgValign valign = Img.getValign(html);
            return Img.build(m, valign, vspace);
        }
        Matcher m = noSrcColonPattern.matcher(html);
        return Img.build(m, ImgValign.TOP, 0);
    }

    private static HtmlCommand build(Matcher m, ImgValign valign, int vspace) {
        if (!m.find()) {
            return new Text("(SYNTAX ERROR)");
        }
        String src = m.group(1);
        try {
            File f = FileSystem.getInstance().getFile(src);
            if (!f.exists()) {
                if (src.startsWith("http:") || src.startsWith("https:")) {
                    byte[] image = Img.getFile(src);
                    BufferedImage read = ImageIO.read(new ByteArrayInputStream(image));
                    if (read == null) {
                        return new Text("(Cannot decode: " + src + ")");
                    }
                    return new Img(new TileImage(read, valign, vspace));
                }
                return new Text("(File not found: " + f + ")");
            }
            if (f.getName().endsWith(".svg")) {
                return new Img(new TileImageSvg(f));
            }
            BufferedImage read = ImageIO.read(f);
            if (read == null) {
                return new Text("(Cannot decode: " + f + ")");
            }
            return new Img(new TileImage(ImageIO.read(f), valign, vspace));
        }
        catch (IOException e) {
            return new Text("ERROR " + e.toString());
        }
    }

    public TextBlock createMonoImage() {
        return this.tileImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFile(String host) throws IOException {
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        InputStream input = null;
        try {
            int read;
            URL url = new URL(host);
            URLConnection connection = url.openConnection();
            input = connection.getInputStream();
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer)) > 0) {
                image.write(buffer, 0, read);
            }
            image.close();
            byte[] byArray = image.toByteArray();
            return byArray;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

