/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import net.sourceforge.plantuml.sequencediagram.teoz.YPositionedTile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GroupingTile
implements TileWithCallbackY {
    private static final int MARGINX = 16;
    private static final int MARGINY = 10;
    private final List<Tile> tiles = new ArrayList<Tile>();
    private final Real min;
    private final Real max;
    private final GroupingStart start;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Display display;
    private double bodyHeight;
    private double y;

    @Override
    public Event getEvent() {
        return this.start;
    }

    public GroupingTile(Iterator<Event> it, GroupingStart start, TileArguments tileArgumentsBachColorChanged, TileArguments tileArgumentsOriginal) {
        Event ev;
        StringBounder stringBounder = tileArgumentsOriginal.getStringBounder();
        this.start = start;
        this.display = start.getTitle().equals("group") ? Display.create(start.getComment()) : Display.create(start.getTitle(), start.getComment());
        this.skin = tileArgumentsOriginal.getSkin();
        this.skinParam = tileArgumentsBachColorChanged.getSkinParam();
        ArrayList<Real> min2 = new ArrayList<Real>();
        ArrayList<Real> max2 = new ArrayList<Real>();
        ArrayList<Tile> allElses = new ArrayList<Tile>();
        while (it.hasNext() && (!((ev = it.next()) instanceof GroupingLeaf) || ((Grouping)ev).getType() != GroupingType.END)) {
            Tile tile = TileBuilder.buildOne(it, tileArgumentsOriginal, ev, this);
            if (tile == null) continue;
            this.tiles.add(tile);
            this.bodyHeight += tile.getPreferredHeight(stringBounder);
            if (ev instanceof GroupingLeaf && ((Grouping)ev).getType() == GroupingType.ELSE) {
                allElses.add(tile);
                continue;
            }
            min2.add(tile.getMinX(stringBounder).addFixed(-16.0));
            Real m = tile.getMaxX(stringBounder);
            max2.add(m.addFixed(16.0));
        }
        Dimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        double width = dim1.getWidth();
        if (min2.size() == 0) {
            min2.add(tileArgumentsOriginal.getOrigin());
        }
        this.min = RealUtils.min(min2);
        for (Tile anElse : allElses) {
            max2.add(anElse.getMaxX(stringBounder));
        }
        max2.add(this.min.addFixed(width + 16.0));
        this.max = RealUtils.max(max2);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(ComponentType.GROUPING_HEADER, null, this.skinParam, this.display);
        return comp;
    }

    private Dimension2D getPreferredDimensionIfEmpty(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getPreferredDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), this.getTotalHeight(stringBounder));
        if (!(ug instanceof LiveBoxFinder)) {
            comp.drawU(ug.apply(new UTranslate(this.min.getCurrentValue(), 0.0)), area, (Context2D)((Object)ug));
            this.drawAllElses(ug);
        }
        double h = dim1.getHeight() + 5.0;
        for (Tile tile : this.tiles) {
            ug.apply(new UTranslate(0.0, h)).draw(tile);
            h += tile.getPreferredHeight(stringBounder);
        }
    }

    private double getTotalHeight(StringBounder stringBounder) {
        Dimension2D dimIfEmpty = this.getPreferredDimensionIfEmpty(stringBounder);
        return this.bodyHeight + dimIfEmpty.getHeight() + 5.0;
    }

    private void drawAllElses(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double totalHeight = this.getTotalHeight(stringBounder);
        double suppHeight = this.getPreferredDimensionIfEmpty(stringBounder).getHeight() + 5.0;
        ArrayList<Double> ys = new ArrayList<Double>();
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            ElseTile elseTile = (ElseTile)tile;
            ys.add(elseTile.getCallbackY() - this.y + suppHeight);
        }
        ys.add(totalHeight);
        int i = 0;
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            ElseTile elseTile = (ElseTile)tile;
            Component comp = elseTile.getComponent(stringBounder);
            Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), (Double)ys.get(i + 1) - (Double)ys.get(i));
            comp.drawU(ug.apply(new UTranslate(this.min.getCurrentValue(), (Double)ys.get(i))), area, (Context2D)((Object)ug));
            ++i;
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        return dim1.getHeight() + this.bodyHeight + 10.0;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }

    @Override
    public void callbackY(double y) {
        this.y = y;
    }

    public static double fillPositionelTiles(StringBounder stringBounder, double y, List<Tile> tiles, List<YPositionedTile> positionedTiles) {
        double lastY = y;
        for (Tile tile : tiles) {
            if (tile.getEvent().isParallel()) {
                y = lastY;
            }
            positionedTiles.add(new YPositionedTile(tile, y));
            if (tile instanceof GroupingTile) {
                GroupingTile groupingTile = (GroupingTile)tile;
                GroupingTile.fillPositionelTiles(stringBounder, y, groupingTile.tiles, new ArrayList<YPositionedTile>());
            }
            lastY = y;
            y += tile.getPreferredHeight(stringBounder);
        }
        return y;
    }
}

