/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseDivider
extends AbstractTextualComponent {
    private final HtmlColor borderColor;
    private final HtmlColor background;
    private final boolean empty;
    private final boolean withShadow;
    private final UStroke stroke;

    public ComponentRoseDivider(FontConfiguration font, HtmlColor background, Display stringsToDisplay, ISkinSimple spriteContainer, boolean withShadow, UStroke stroke, HtmlColor borderColor) {
        super(stringsToDisplay, font, HorizontalAlignment.CENTER, 4, 4, 4, spriteContainer, 0.0, false, null, null);
        this.background = background;
        this.borderColor = borderColor;
        this.empty = stringsToDisplay.get(0).length() == 0;
        this.withShadow = withShadow;
        this.stroke = stroke;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(new UChangeBackColor(this.background));
        if (this.empty) {
            this.drawSep(ug.apply(new UTranslate(0.0, dimensionToUse.getHeight() / 2.0)), dimensionToUse.getWidth());
        } else {
            TextBlock textBlock = this.getTextBlock();
            StringBounder stringBounder = ug.getStringBounder();
            double textWidth = this.getTextWidth(stringBounder);
            double textHeight = this.getTextHeight(stringBounder);
            double deltaX = 6.0;
            double xpos = (dimensionToUse.getWidth() - textWidth - 6.0) / 2.0;
            double ypos = (dimensionToUse.getHeight() - textHeight) / 2.0;
            this.drawSep(ug.apply(new UTranslate(0.0, dimensionToUse.getHeight() / 2.0)), dimensionToUse.getWidth());
            ug = ug.apply(new UChangeColor(this.borderColor));
            ug = ug.apply(this.stroke);
            URectangle rect = new URectangle(textWidth + 6.0, textHeight);
            if (this.withShadow) {
                rect.setDeltaShadow(4.0);
            }
            ug.apply(new UTranslate(xpos, ypos)).draw(rect);
            textBlock.drawU(ug.apply(new UTranslate(xpos + 6.0, ypos + (double)this.getMarginY())));
        }
    }

    private void drawSep(UGraphic ug, double width) {
        ug = ug.apply(new UChangeColor(this.background));
        this.drawRectLong(ug.apply(new UTranslate(0.0, -1.0)), width);
        this.drawDoubleLine(ug, width);
    }

    private void drawRectLong(UGraphic ug, double width) {
        URectangle rectLong = new URectangle(width, 3.0);
        if (this.withShadow) {
            rectLong.setDeltaShadow(2.0);
        }
        ug = ug.apply(new UStroke());
        ug.draw(rectLong);
    }

    private void drawDoubleLine(UGraphic ug, double width) {
        ug = ug.apply(new UStroke(this.stroke.getThickness() / 2.0)).apply(new UChangeColor(this.borderColor));
        ULine line = new ULine(width, 0.0);
        ug.apply(new UTranslate(0.0, -1.0)).draw(line);
        ug.apply(new UTranslate(0.0, 2.0)).draw(line);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

