/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class StartUtils {
    private static final Pattern append = MyPattern.cmpile("^\\W*@append");

    public static boolean isArobaseStartDiagram(CharSequence s) {
        return StringUtils.trinNoTrace(s).startsWith("@start");
    }

    public static boolean isArobaseEndDiagram(CharSequence s) {
        return StringUtils.trinNoTrace(s).startsWith("@end");
    }

    public static boolean isArobasePauseDiagram(CharSequence s) {
        return StringUtils.trinNoTrace(s).startsWith("@pause");
    }

    public static boolean isArobaseUnpauseDiagram(CharSequence s) {
        return StringUtils.trinNoTrace(s).startsWith("@unpause");
    }

    public static CharSequence2 getPossibleAppend(CharSequence2 s) {
        Matcher m = append.matcher(s);
        if (m.find()) {
            return s.subSequence(m.group(0).length(), s.length()).trin();
        }
        return null;
    }
}

