/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.gui;

import com.ctreber.aclib.gui.MonitoredObject;

public class MODouble
extends MonitoredObject {
    private double fDouble;
    private boolean fCheckRange = false;
    private double fMin;
    private double fMax;

    public MODouble() {
    }

    public MODouble(double pDouble) {
        this.fDouble = pDouble;
    }

    public MODouble(double pDouble, double pMin, double pMax) {
        this.fMin = pMin;
        this.fMax = pMax;
        this.fCheckRange = true;
        this.set(pDouble);
    }

    public void set(double pDouble) {
        if (!this.checkRange(pDouble)) {
            throw new IllegalArgumentException("Argument '" + pDouble + "' out of range [" + MODouble.niceFormat(this.fMin) + "; " + MODouble.niceFormat(this.fMax) + "]");
        }
        this.fDouble = pDouble;
        this.fireValueChanged();
    }

    private static String niceFormat(double pDouble) {
        if (pDouble == Double.MAX_VALUE) {
            return "Infinity";
        }
        if (pDouble == Double.MIN_VALUE) {
            return "-Infinity";
        }
        return Double.toString(pDouble);
    }

    public double get() {
        return this.fDouble;
    }

    private boolean checkRange(double pDouble) {
        return !this.fCheckRange || this.fMin <= pDouble && pDouble <= this.fMax;
    }

    @Override
    public boolean checkRange() {
        return this.checkRange(this.fDouble);
    }
}

