/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class PSystemError
extends AbstractPSystem {
    private final int higherErrorPosition;
    private final List<ErrorUml> printedErrors;
    private final List<String> debugLines = new ArrayList<String>();

    public PSystemError(UmlSource source, ErrorUml singleError, List<String> debugLines) {
        this(source, Collections.singletonList(singleError), debugLines);
    }

    private PSystemError(UmlSource source, List<ErrorUml> all, List<String> debugLines) {
        this.setSource(source);
        int higherErrorPositionExecution = this.getHigherErrorPosition(ErrorUmlType.EXECUTION_ERROR, all);
        int higherErrorPositionSyntax = this.getHigherErrorPosition(ErrorUmlType.SYNTAX_ERROR, all);
        if (higherErrorPositionExecution == Integer.MIN_VALUE && higherErrorPositionSyntax == Integer.MIN_VALUE) {
            throw new IllegalStateException();
        }
        if (higherErrorPositionExecution >= higherErrorPositionSyntax) {
            this.higherErrorPosition = higherErrorPositionExecution;
            this.printedErrors = this.getErrorsAt(higherErrorPositionExecution, ErrorUmlType.EXECUTION_ERROR, all);
        } else {
            assert (higherErrorPositionSyntax > higherErrorPositionExecution);
            this.higherErrorPosition = higherErrorPositionSyntax;
            this.printedErrors = this.getErrorsAt(higherErrorPositionSyntax, ErrorUmlType.SYNTAX_ERROR, all);
        }
        if (debugLines != null) {
            this.debugLines.addAll(debugLines);
        }
    }

    private String getSuggestColor(boolean useRed) {
        if (useRed) {
            return "black";
        }
        return "white";
    }

    private String getRed(boolean useRed) {
        if (useRed) {
            return "#CD0A0A";
        }
        return "red";
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT || fileFormat.getFileFormat() == FileFormat.UTXT) {
            UGraphicTxt ugt = new UGraphicTxt();
            UmlCharArea area = ugt.getCharArea();
            area.drawStringsLR(this.getTextStrings(), 0, 0);
            area.print(new PrintStream(os));
            return new ImageDataSimple(1, 1);
        }
        boolean useRed = fileFormat.isUseRedForError();
        GraphicStrings result = GraphicStrings.createDefault(this.getHtmlStrings(useRed), useRed);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.addUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    private List<String> getTextStrings() {
        int start;
        ArrayList<String> result = new ArrayList<String>(this.getStack());
        if (result.size() > 0) {
            result.add(" ");
        }
        int limit = 4;
        int skip = this.higherErrorPosition - 4 + 1;
        if (skip <= 0) {
            start = 0;
        } else {
            if (skip == 1) {
                result.add("... (skipping 1 line) ...");
            } else {
                result.add("... (skipping " + skip + " lines) ...");
            }
            start = this.higherErrorPosition - 4 + 1;
        }
        for (int i = start; i < this.higherErrorPosition; ++i) {
            result.add(this.getSource().getLine(i));
        }
        String errorLine = this.getSource().getLine(this.higherErrorPosition);
        String err = StringUtils.hideComparatorCharacters(errorLine);
        if (StringUtils.isNotEmpty(err)) {
            result.add(err);
        }
        StringBuilder underscore = new StringBuilder();
        for (int i = 0; i < errorLine.length(); ++i) {
            underscore.append("^");
        }
        result.add(underscore.toString());
        LinkedHashSet<String> textErrors = new LinkedHashSet<String>();
        for (ErrorUml errorUml : this.printedErrors) {
            textErrors.add(errorUml.getError());
        }
        for (String string : textErrors) {
            result.add(" " + string);
        }
        boolean first = true;
        for (String s : this.getSuggest()) {
            if (first) {
                result.add(" " + s);
            } else {
                result.add(s);
            }
            first = false;
        }
        result.addAll(this.debugLines);
        return result;
    }

    private List<String> getStack() {
        LineLocation lineLocation = this.getLineLocation();
        ArrayList<String> result = new ArrayList<String>();
        if (lineLocation != null) {
            this.append(result, lineLocation);
            while (lineLocation.getParent() != null) {
                lineLocation = lineLocation.getParent();
                this.append(result, lineLocation);
            }
        }
        return result;
    }

    public LineLocation getLineLocation() {
        for (ErrorUml err : this.printedErrors) {
            if (err.getLineLocation() == null) continue;
            return err.getLineLocation();
        }
        return null;
    }

    private void append(List<String> result, LineLocation lineLocation) {
        if (lineLocation.getDescription() != null) {
            result.add("[From " + lineLocation.getDescription() + " (line " + (lineLocation.getPosition() + 1) + ") ]");
        }
    }

    private List<String> getHtmlStrings(boolean useRed) {
        int start;
        ArrayList<String> htmlStrings = new ArrayList<String>(this.getStack());
        if (htmlStrings.size() > 0) {
            htmlStrings.add("----");
        }
        int limit = 4;
        int skip = this.higherErrorPosition - 4 + 1;
        if (skip <= 0) {
            start = 0;
        } else {
            if (skip == 1) {
                htmlStrings.add("... (skipping 1 line) ...");
            } else {
                htmlStrings.add("... (skipping " + skip + " lines) ...");
            }
            start = this.higherErrorPosition - 4 + 1;
        }
        for (int i = start; i < this.higherErrorPosition; ++i) {
            htmlStrings.add(StringUtils.hideComparatorCharacters(this.getSource().getLine(i)));
        }
        String errorLine = this.getSource().getLine(this.higherErrorPosition);
        String err = StringUtils.hideComparatorCharacters(errorLine);
        if (StringUtils.isNotEmpty(err)) {
            htmlStrings.add("<w:" + this.getRed(useRed) + ">" + err + "</w>");
        }
        LinkedHashSet<String> textErrors = new LinkedHashSet<String>();
        for (ErrorUml errorUml : this.printedErrors) {
            textErrors.add(errorUml.getError());
        }
        for (String string : textErrors) {
            htmlStrings.add(" <color:" + this.getRed(useRed) + ">" + string + "</color>");
        }
        boolean first = true;
        for (String s : this.getSuggest()) {
            if (first) {
                htmlStrings.add(" <color:" + this.getSuggestColor(useRed) + "><i>" + s + "</i></color>");
            } else {
                htmlStrings.add("<color:" + this.getSuggestColor(useRed) + ">" + StringUtils.hideComparatorCharacters(s) + "</color>");
            }
            first = false;
        }
        htmlStrings.addAll(this.debugLines);
        return htmlStrings;
    }

    public List<String> getSuggest() {
        boolean suggested = false;
        for (ErrorUml er : this.printedErrors) {
            if (!er.hasSuggest()) continue;
            suggested = true;
        }
        if (!suggested) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("Did you mean:");
        for (ErrorUml er : this.printedErrors) {
            if (!er.hasSuggest()) continue;
            result.add(er.getSuggest().getSuggestedLine());
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<ErrorUml> getErrors(ErrorUmlType type, List<ErrorUml> all) {
        LinkedHashSet<ErrorUml> result = new LinkedHashSet<ErrorUml>();
        for (ErrorUml error : all) {
            if (error.getType() != type) continue;
            result.add(error);
        }
        return result;
    }

    private int getHigherErrorPosition(ErrorUmlType type, List<ErrorUml> all) {
        int max = Integer.MIN_VALUE;
        for (ErrorUml error : this.getErrors(type, all)) {
            if (error.getPosition() <= max) continue;
            max = error.getPosition();
        }
        return max;
    }

    private List<ErrorUml> getErrorsAt(int position, ErrorUmlType type, List<ErrorUml> all) {
        ArrayList<ErrorUml> result = new ArrayList<ErrorUml>();
        for (ErrorUml error : this.getErrors(type, all)) {
            if (error.getPosition() != position || !StringUtils.isNotEmpty(error.getError())) continue;
            result.add(error);
        }
        return result;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Error)", this.getClass());
    }

    public final int getHigherErrorPosition() {
        return this.higherErrorPosition;
    }

    public final Collection<ErrorUml> getErrorsUml() {
        return Collections.unmodifiableCollection(this.printedErrors);
    }

    @Override
    public String getWarningOrError() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDescription());
        sb.append('\n');
        for (CharSequence t : this.getTitle()) {
            sb.append(t);
            sb.append('\n');
        }
        sb.append('\n');
        for (String s : this.getSuggest()) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static PSystemError merge(Collection<PSystemError> ps) {
        UmlSource source = null;
        ArrayList<ErrorUml> errors = new ArrayList<ErrorUml>();
        ArrayList<String> debugs = new ArrayList<String>();
        for (PSystemError system : ps) {
            if (system == null) continue;
            if (system.getSource() != null && source == null) {
                source = system.getSource();
            }
            errors.addAll(system.getErrorsUml());
            debugs.addAll(system.debugLines);
            if (system.debugLines.size() <= 0) continue;
            debugs.add("-");
        }
        if (source == null) {
            throw new IllegalStateException();
        }
        return new PSystemError(source, errors, debugs);
    }
}

