/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.acearth;

import com.ctreber.acearth.ACearth;
import com.ctreber.acearth.ConfigurationACearth;
import com.ctreber.acearth.plugins.markers.Marker;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;

public class PSystemXearth
extends AbstractPSystem {
    private final int width;
    private final int height;
    private final Map<String, String> config;
    private final List<Marker> markers;
    private final Collection<String> enums = Arrays.asList("viewPositionType");
    private final Collection<String> doubles = Arrays.asList("sunPosRelLat", "sunPosRelLong", "orbitPeriod", "orbitInclination", "viewPosLat", "viewPosLong", "starFrequency", "viewMagnification");
    private final Collection<String> integers = Arrays.asList("daySideBrightness", "nightSideBrightness", "terminatorDiscontinuity", "gridDivision", "gridPixelDivision", "bigStars");
    private final Collection<String> booleans = Arrays.asList("shadeP", "gridP", "starsP");

    public PSystemXearth(int width, int height, Map<String, String> config, List<Marker> markers) {
        this.width = width;
        this.height = height;
        this.config = config;
        this.markers = markers;
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        ACearth earth = new ACearth(this.markers);
        ConfigurationACearth conf = earth.getConf();
        conf.setInt("imageWidth", this.width);
        conf.setInt("imageHeight", this.height);
        for (Map.Entry<String, String> ent : this.config.entrySet()) {
            String key = ent.getKey();
            String value = ent.getValue();
            if (key.equalsIgnoreCase("GMT")) {
                Date date = this.extractGmt(value);
                conf.setInt("fixedTime", (int)(date.getTime() / 1000L));
                continue;
            }
            if (this.enums.contains(key)) {
                conf.getMOEnum(key).set(value);
                continue;
            }
            if (this.doubles.contains(key)) {
                conf.setDouble(key, Double.parseDouble(value));
                continue;
            }
            if (this.integers.contains(key)) {
                conf.setInt(key, Integer.parseInt(value));
                continue;
            }
            if (this.booleans.contains(key)) {
                conf.setBoolean(key, value.equalsIgnoreCase("true"));
                continue;
            }
            throw new UnsupportedOperationException(key);
        }
        earth.exportPng(os);
        return new ImageDataSimple(this.width, this.height);
    }

    private Date extractGmt(String s) {
        SimpleDateFormat timeFormat;
        if (s.matches("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            timeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        } else if (s.matches("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}")) {
            timeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        } else {
            throw new UnsupportedOperationException(s);
        }
        timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return timeFormat.parse(s);
        }
        catch (ParseException e) {
            throw new UnsupportedOperationException(s);
        }
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(XEarth)", this.getClass());
    }
}

