/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.color.ColorParser;

public final class FactoryNoteCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^(note)[%s]+"), new RegexLeaf("CODE", "as[%s]+([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("DISPLAY", "[%g]([^%g]+)[%g][%s]+as[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        return new SingleLineCommand2<AbstractEntityDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(AbstractEntityDiagram system, RegexResult arg) {
                String display = arg.get("DISPLAY", 0);
                return FactoryNoteCommand.this.executeInternal(system, arg, BlocLines.getWithNewlines(display));
            }
        };
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(AbstractEntityDiagram system, BlocLines lines) {
                RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactoryNoteCommand.this.executeInternal(system, line0, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(AbstractEntityDiagram diagram, RegexResult arg, BlocLines display) {
        Code code = Code.of(arg.get("CODE", 0));
        if (diagram.leafExist(code)) {
            return CommandExecutionResult.error("Note already created: " + code.getFullName());
        }
        ILeaf entity = diagram.createLeaf(code, display.toDisplay(), LeafType.NOTE, null);
        assert (entity != null);
        entity.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }
}

