/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.compositediagram.command;

import java.util.List;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.compositediagram.CompositeDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public class CommandLinkBlock
extends SingleLineCommand<CompositeDiagram> {
    public CommandLinkBlock() {
        super("(?i)^([\\p{L}0-9_.]+)[%s]*(\\[\\]|\\*\\))?([=-]+|\\.+)(\\[\\]|\\(\\*)?[%s]*([\\p{L}0-9_.]+)[%s]*(?::[%s]*(\\S*+))?$");
    }

    @Override
    protected CommandExecutionResult executeArg(CompositeDiagram diagram, List<String> arg) {
        IEntity cl1 = diagram.getOrCreateLeaf(Code.of(arg.get(0)), null, null);
        IEntity cl2 = diagram.getOrCreateLeaf(Code.of(arg.get(4)), null, null);
        String deco1 = arg.get(1);
        String deco2 = arg.get(3);
        LinkType linkType = new LinkType(this.getLinkDecor(deco1), this.getLinkDecor(deco2));
        if ("*)".equals(deco1)) {
            linkType = linkType.getInterfaceProvider();
        } else if ("(*".equals(deco2)) {
            linkType = linkType.getInterfaceUser();
        }
        String queue = arg.get(2);
        Link link = new Link(cl1, cl2, linkType, Display.getWithNewlines(arg.get(5)), queue.length());
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private LinkDecor getLinkDecor(String s) {
        if ("[]".equals(s)) {
            return LinkDecor.SQUARRE_toberemoved;
        }
        return LinkDecor.NONE;
    }
}

